/*
 * Decompiled with CFR 0.152.
 */
package capstone.jni;

import capstone.Capstone;
import capstone.api.Disassembler;
import capstone.api.Instruction;
import capstone.jni.FastInstruction;
import capstone.jni.RegsAccess;
import java.io.IOException;
import org.scijava.nativelib.NativeLoader;

public class FastDisassembler
implements Disassembler {
    private final long nativeHandle;
    private boolean closed;

    private static native long nativeInitialize(boolean var0, int var1);

    private static native int nativeDestroy(long var0);

    private static native int setDetail(long var0, boolean var2);

    private native FastInstruction[] disasm(long var1, byte[] var3, long var4, long var6);

    private static native String regName(long var0, int var2);

    static native void cs_free(long var0, long var2);

    private static native RegsAccess regsAccess(long var0, long var2);

    private static native Capstone.OpInfo getOpInfo(long var0, long var2);

    private static native int mapToUnicornReg(long var0, int var2);

    private static native int mapToCapstoneReg(long var0, int var2);

    final RegsAccess regsAccess(long insn) {
        return FastDisassembler.regsAccess(this.nativeHandle, insn);
    }

    final Capstone.OpInfo getOpInfo(long insn) {
        return FastDisassembler.getOpInfo(this.nativeHandle, insn);
    }

    final String regName(int regId) {
        return FastDisassembler.regName(this.nativeHandle, regId);
    }

    public FastDisassembler(int arch, int mode) {
        boolean is64Bit;
        if (arch == 0) {
            is64Bit = false;
        } else if (arch == 1) {
            is64Bit = true;
        } else {
            throw new UnsupportedOperationException("arch=" + arch);
        }
        this.nativeHandle = FastDisassembler.nativeInitialize(is64Bit, mode);
        if (this.nativeHandle == 0L) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Instruction[] disasm(byte[] code, long address) {
        return this.disasm(code, address, 0L);
    }

    @Override
    public Instruction[] disasm(byte[] code, long address, long count) {
        return this.disasm(this.nativeHandle, code, address, count);
    }

    final int mapToUnicornReg(int capstoneReg) {
        return FastDisassembler.mapToUnicornReg(this.nativeHandle, capstoneReg);
    }

    final int mapToCapstoneReg(int unicornReg) {
        return FastDisassembler.mapToCapstoneReg(this.nativeHandle, unicornReg);
    }

    @Override
    public void setDetail(boolean on) {
        if (FastDisassembler.setDetail(this.nativeHandle, on) != 0) {
            throw new IllegalStateException("ERROR: Failed to set detail option");
        }
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L && !this.closed) {
            try {
                if (FastDisassembler.nativeDestroy(this.nativeHandle) != 0) {
                    throw new IllegalStateException("ERROR: Failed to call cs_close");
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    static {
        try {
            NativeLoader.loadLibrary("disassembler", new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

