/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.github.unidbg.ByteArrayNumber;
import com.github.unidbg.Emulator;
import com.github.unidbg.PointerArg;
import com.github.unidbg.PointerNumber;
import com.github.unidbg.StringNumber;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.InitFunctionListener;
import com.github.unidbg.spi.LibraryFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Module {
    public final String name;
    public final long base;
    public final long size;
    private final LibraryFile libraryFile;
    protected final Map<String, Module> neededLibraries;
    private final List<MemRegion> regions;
    private int referenceCount;
    private boolean forceCallInit;
    protected long entryPoint;
    private UnidbgPointer pathPointer;
    protected InitFunctionListener initFunctionListener;

    public Module(String name, long base, long size, Map<String, Module> neededLibraries, List<MemRegion> regions, LibraryFile libraryFile) {
        this.name = name;
        this.base = base;
        this.size = size;
        this.neededLibraries = neededLibraries;
        this.regions = regions;
        this.libraryFile = libraryFile;
    }

    public long getFileSize() {
        return this.libraryFile == null ? 0L : this.libraryFile.getFileSize();
    }

    public long getBaseHeader() {
        return this.base;
    }

    public final List<MemRegion> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public abstract Number callFunction(Emulator<?> var1, long var2, Object ... var4);

    public final Number callFunction(Emulator<?> emulator, String symbolName, Object ... args) {
        Symbol symbol = this.findSymbolByName(symbolName, false);
        if (symbol == null) {
            throw new IllegalStateException("find symbol failed: " + symbolName);
        }
        if (symbol.isUndef()) {
            throw new IllegalStateException(symbolName + " is NOT defined");
        }
        return symbol.call(emulator, args);
    }

    public final Symbol findSymbolByName(String name) {
        return this.findSymbolByName(name, true);
    }

    public abstract Symbol findSymbolByName(String var1, boolean var2);

    public abstract Symbol findClosestSymbolByAddress(long var1, boolean var3);

    protected final Symbol findDependencySymbolByName(String name) {
        for (Module module : this.neededLibraries.values()) {
            Symbol symbol = module.findSymbolByName(name, true);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public void addReferenceCount() {
        ++this.referenceCount;
    }

    public int decrementReferenceCount() {
        return --this.referenceCount;
    }

    public boolean isForceCallInit() {
        return this.forceCallInit;
    }

    public void setForceCallInit() {
        this.forceCallInit = true;
    }

    public final void unload(Backend backend) {
        for (MemRegion region : this.regions) {
            backend.mem_unmap(region.begin, region.end - region.begin);
        }
    }

    public Collection<Module> getNeededLibraries() {
        return this.neededLibraries.values();
    }

    public Module getDependencyModule(String name) {
        return this.neededLibraries.get(name);
    }

    public void setEntryPoint(long entryPoint) {
        this.entryPoint = entryPoint;
    }

    public abstract int callEntry(Emulator<?> var1, String ... var2);

    public abstract String getPath();

    public abstract void registerSymbol(String var1, long var2);

    public final UnidbgPointer createPathMemory(SvcMemory svcMemory) {
        if (this.pathPointer == null) {
            byte[] bytes = this.getPath().getBytes(StandardCharsets.UTF_8);
            byte[] path = Arrays.copyOf(bytes, bytes.length + 1);
            this.pathPointer = svcMemory.allocate(path.length, "Module.path: " + this.getPath());
            this.pathPointer.write(0L, path, 0, path.length);
        }
        return this.pathPointer;
    }

    public static Number emulateFunction(Emulator<?> emulator, long address, Object ... args) {
        ArrayList<Number> list = new ArrayList<Number>(args.length);
        for (Object arg : args) {
            if (arg instanceof String) {
                list.add(new StringNumber((String)arg));
                continue;
            }
            if (arg instanceof byte[]) {
                list.add(new ByteArrayNumber((byte[])arg));
                continue;
            }
            if (arg instanceof PointerArg) {
                PointerArg pointerArg = (PointerArg)arg;
                list.add(new PointerNumber((UnidbgPointer)pointerArg.getPointer()));
                continue;
            }
            if (arg instanceof Number) {
                list.add((Number)arg);
                continue;
            }
            if (arg == null) {
                list.add(new PointerNumber(null));
                continue;
            }
            throw new IllegalStateException("Unsupported arg: " + arg);
        }
        return emulator.eFunc(address, list.toArray(new Number[0]));
    }

    public boolean isVirtual() {
        return false;
    }

    public abstract int virtualMemoryAddressToFileOffset(long var1);

    public void setInitFunctionListener(InitFunctionListener initFunctionListener) {
        this.initFunctionListener = initFunctionListener;
    }
}

