/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import capstone.api.Instruction;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.Cpsr;
import com.github.unidbg.arm.backend.Backend;
import java.util.Locale;

final class RegAccessPrinter {
    private final long address;
    private final Instruction instruction;
    private final short[] accessRegs;
    private boolean forWriteRegs;

    public RegAccessPrinter(long address, Instruction instruction, short[] accessRegs, boolean forWriteRegs) {
        this.address = address;
        this.instruction = instruction;
        this.accessRegs = accessRegs;
        this.forWriteRegs = forWriteRegs;
    }

    public void print(Emulator<?> emulator, Backend backend, StringBuilder builder, long address) {
        if (this.address != address) {
            return;
        }
        for (short reg : this.accessRegs) {
            int regId = this.instruction.mapToUnicornReg(reg);
            if (emulator.is32Bit()) {
                if ((regId < 66 || regId > 78) && regId != 10 && regId != 12 && regId != 3) continue;
                if (this.forWriteRegs) {
                    builder.append(" =>");
                    this.forWriteRegs = false;
                }
                if (regId == 3) {
                    Cpsr cpsr = Cpsr.getArm(backend);
                    builder.append(String.format(Locale.US, " cpsr: N=%d, Z=%d, C=%d, V=%d", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0));
                    continue;
                }
                int value = backend.reg_read(regId).intValue();
                builder.append(' ').append(this.instruction.regName(reg)).append("=0x").append(Long.toHexString((long)value & 0xFFFFFFFFL));
                continue;
            }
            if (regId >= 199 && regId <= 227 || regId >= 1 && regId <= 4) {
                if (this.forWriteRegs) {
                    builder.append(" =>");
                    this.forWriteRegs = false;
                }
                if (regId == 3) {
                    Cpsr cpsr = Cpsr.getArm64(backend);
                    if (cpsr.isA32()) {
                        builder.append(String.format(Locale.US, " cpsr: N=%d, Z=%d, C=%d, V=%d", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0));
                        continue;
                    }
                    builder.append(String.format(Locale.US, " nzcv: N=%d, Z=%d, C=%d, V=%d", cpsr.isNegative() ? 1 : 0, cpsr.isZero() ? 1 : 0, cpsr.hasCarry() ? 1 : 0, cpsr.isOverflow() ? 1 : 0));
                    continue;
                }
                long value = backend.reg_read(regId).longValue();
                builder.append(' ').append(this.instruction.regName(reg)).append("=0x").append(Long.toHexString(value));
                continue;
            }
            if (regId < 168 || regId > 198) continue;
            if (this.forWriteRegs) {
                builder.append(" =>");
                this.forWriteRegs = false;
            }
            int value = backend.reg_read(regId).intValue();
            builder.append(' ').append(this.instruction.regName(reg)).append("=0x").append(Long.toHexString((long)value & 0xFFFFFFFFL));
        }
    }
}

