/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.TraceHook;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.listener.TraceReadListener;
import com.github.unidbg.listener.TraceWriteListener;
import com.github.unidbg.pointer.UnidbgPointer;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;

public class TraceMemoryHook
implements ReadHook,
WriteHook,
TraceHook {
    private final boolean read;
    private final DateFormat dateFormat = new SimpleDateFormat("[HH:mm:ss SSS]");
    private PrintStream redirect;
    TraceReadListener traceReadListener;
    TraceWriteListener traceWriteListener;
    private UnHook unHook;

    public TraceMemoryHook(boolean read) {
        this.read = read;
    }

    @Override
    public void onAttach(UnHook unHook) {
        if (this.unHook != null) {
            throw new IllegalStateException();
        }
        this.unHook = unHook;
    }

    @Override
    public void detach() {
        if (this.unHook != null) {
            this.unHook.unhook();
            this.unHook = null;
        }
    }

    @Override
    public void stopTrace() {
        this.detach();
        IOUtils.close(this.redirect);
        this.redirect = null;
    }

    @Override
    public void setRedirect(PrintStream redirect) {
        this.redirect = redirect;
    }

    @Override
    public void hook(Backend backend, long address, int size, Object user) {
        if (!this.read) {
            return;
        }
        try {
            byte[] data2;
            byte[] byArray = data2 = size == 0 ? new byte[]{} : backend.mem_read(address, size);
            String value = data2.length == 2 ? "0x" + Long.toHexString((long)ByteBuffer.wrap(data2).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFFL) : (data2.length == 4 ? "0x" + Long.toHexString((long)ByteBuffer.wrap(data2).order(ByteOrder.LITTLE_ENDIAN).getInt() & 0xFFFFFFFFL) : (data2.length == 8 ? "0x" + Long.toHexString(ByteBuffer.wrap(data2).order(ByteOrder.LITTLE_ENDIAN).getLong()) : "0x" + Hex.encodeHexString(data2)));
            Emulator emulator = (Emulator)user;
            if (this.traceReadListener == null || this.traceReadListener.onRead(emulator, address, data2, value)) {
                this.printMsg(this.dateFormat.format(new Date()) + " Memory READ at 0x", emulator, address, size, value);
            }
        }
        catch (BackendException e) {
            throw new IllegalStateException(e);
        }
    }

    private void printMsg(String type, Emulator<?> emulator, long address, int size, String value) {
        Object context = emulator.getContext();
        UnidbgPointer pc = context.getPCPointer();
        UnidbgPointer lr = context.getLRPointer();
        PrintStream out = System.out;
        if (this.redirect != null) {
            out = this.redirect;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(type).append(Long.toHexString(address));
        if (size > 0) {
            builder.append(", data size = ").append(size).append(", data value = ").append(value);
        }
        builder.append(", PC=").append(pc).append(", LR=").append(lr);
        out.println(builder);
    }

    @Override
    public void hook(Backend backend, long address, int size, long value, Object user) {
        if (this.read) {
            return;
        }
        try {
            Emulator emulator = (Emulator)user;
            if (this.traceWriteListener == null || this.traceWriteListener.onWrite(emulator, address, size, value)) {
                this.printMsg(this.dateFormat.format(new Date()) + " Memory WRITE at 0x", emulator, address, size, "0x" + Long.toHexString(value));
            }
        }
        catch (BackendException e) {
            throw new IllegalStateException(e);
        }
    }
}

