/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String toUUID(byte[] data2) {
        int i;
        if (data2 == null) {
            return null;
        }
        long msb = 0L;
        long lsb = 0L;
        assert (data2.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data2[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data2[i] & 0xFF);
        }
        long mostSigBits = msb;
        long leastSigBits = lsb;
        return (Utils.digits(mostSigBits >> 32, 8) + "-" + Utils.digits(mostSigBits >> 16, 4) + "-" + Utils.digits(mostSigBits, 4) + "-" + Utils.digits(leastSigBits >> 48, 4) + "-" + Utils.digits(leastSigBits, 12)).toUpperCase();
    }

    public static long readSignedLeb128(ByteBuffer buffer, int size) {
        long b;
        int shift = 0;
        long value = 0L;
        do {
            b = buffer.get() & 0xFF;
            value |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        if (shift < size && (b & 0x40L) != 0L) {
            value |= -(1L << shift);
        }
        return value;
    }

    public static BigInteger readULEB128(ByteBuffer buffer) {
        BigInteger result = BigInteger.ZERO;
        int shift = 0;
        while (true) {
            byte b = buffer.get();
            result = result.or(BigInteger.valueOf(b & 0x7F).shiftLeft(shift));
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public static ByteBuffer mapBuffer(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MappedByteBuffer mappedByteBuffer;
            block11: {
                FileChannel channel = inputStream.getChannel();
                try {
                    mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                    if (channel == null) break block11;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return mappedByteBuffer;
        }
    }

    public static int readFile(RandomAccessFile randomAccessFile, Pointer buffer, int _count) {
        try {
            int count = _count;
            long remaining = randomAccessFile.length() - randomAccessFile.getFilePointer();
            if ((long)count > remaining && (count = (int)remaining) < 0) {
                log.warn("read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", _count=" + _count + ", length=" + randomAccessFile.length() + ", buffer=" + buffer);
                return 0;
            }
            int total = 0;
            byte[] buf = new byte[Math.min(4096, count)];
            Pointer pointer = buffer;
            while (total < count) {
                int read = randomAccessFile.read(buf, 0, Math.min(buf.length, count - total));
                if (read <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", read=" + read + ", length=" + randomAccessFile.length() + ", buffer=" + buffer);
                    }
                    return total;
                }
                if (randomAccessFile.getFilePointer() > randomAccessFile.length()) {
                    throw new IllegalStateException("fp=" + randomAccessFile.getFilePointer() + ", length=" + randomAccessFile.length());
                }
                if (read > buf.length) {
                    throw new IllegalStateException("count=" + buf.length + ", read=" + read);
                }
                if (log.isDebugEnabled()) {
                    Inspector.inspect(buf, "read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", read=" + read + ", length=" + randomAccessFile.length() + ", buffer=" + buffer);
                }
                pointer.write(0L, buf, 0, read);
                total += read;
                pointer = pointer.share(read);
            }
            return total;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public static File getClassLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public static long parseNumber(String str) {
        if (str.startsWith("0x")) {
            return Long.parseLong(str.substring(2).trim(), 16);
        }
        return Long.parseLong(str);
    }

    public static String decodeVectorRegister(byte[] data2) {
        if (data2.length != 16) {
            throw new IllegalStateException("data.length=" + data2.length);
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(data2);
        buffer.flip();
        boolean twoDouble = false;
        for (int i = 8; i < 16; ++i) {
            if (data2[i] == 0) continue;
            twoDouble = true;
            break;
        }
        if (twoDouble) {
            return String.format("(%s, %s)", buffer.getDouble(), buffer.getDouble());
        }
        boolean isDouble = false;
        for (int i = 4; i < 8; ++i) {
            if (data2[i] == 0) continue;
            isDouble = true;
            break;
        }
        return String.format("(%s)", isDouble ? buffer.getDouble() : (double)buffer.getFloat());
    }
}

