/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import capstone.api.arm.OpInfo;
import capstone.api.arm.Operand;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.TraceFunctionCall;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.debugger.FunctionCallListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class TraceFunctionCall32
extends TraceFunctionCall {
    private static final int ARM_BL_IMM_MASK = 0xF000000;
    private static final int ARM_BL_IMM = 0xB000000;
    private static final int ARM_BL_REG_MASK = 0xFFFFFF0;
    private static final int ARM_BL_REG = 19922736;
    private static final int THUMB_BL_IMM_MASK = -134168576;
    private static final int THUMB_BL_IMM = -268386304;
    private static final short THUMB_BL_REG_MASK = -121;
    private static final short THUMB_BL_REG = 18304;

    public TraceFunctionCall32(Emulator<?> emulator, FunctionCallListener listener) {
        super(emulator, listener);
    }

    @Override
    protected Instruction disassemble(long address, int size) {
        Backend backend = this.emulator.getBackend();
        boolean thumb = ARM.isThumb(backend);
        if (thumb) {
            return this.disassembleThumb(address, size);
        }
        return this.disassembleArm(address, size);
    }

    private Instruction disassembleArm(long address, int size) {
        if (size != 4) {
            throw new IllegalStateException();
        }
        byte[] code = this.emulator.getBackend().mem_read(address, 4L);
        ByteBuffer buffer = ByteBuffer.wrap(code).order(ByteOrder.LITTLE_ENDIAN);
        int value = buffer.getInt();
        if ((value & 0xF000000) == 0xB000000 || (value & 0xFE000000) == -100663296) {
            Instruction[] instructions = this.emulator.disassemble(address, code, false, 1L);
            return instructions[0];
        }
        if ((value & 0xFFFFFF0) == 19922736) {
            Instruction[] instructions = this.emulator.disassemble(address, code, false, 1L);
            return instructions[0];
        }
        return null;
    }

    private Instruction disassembleThumb(long address, int size) {
        byte[] code = this.emulator.getBackend().mem_read(address, size);
        if (size == 4) {
            int t2;
            ByteBuffer buffer = ByteBuffer.wrap(code).order(ByteOrder.LITTLE_ENDIAN);
            int t1 = buffer.getShort() & 0xFFFF;
            int value = t1 << 16 | (t2 = buffer.getShort() & 0xFFFF);
            if ((value & 0xF800C000) == -268386304) {
                Instruction[] instructions = this.emulator.disassemble(address, code, true, 1L);
                return instructions[0];
            }
        } else if (size == 2) {
            ByteBuffer buffer = ByteBuffer.wrap(code).order(ByteOrder.LITTLE_ENDIAN);
            short value = buffer.getShort();
            if ((value & 0xFFFFFF87) == 18304) {
                Instruction[] instructions = this.emulator.disassemble(address, code, true, 1L);
                return instructions[0];
            }
        } else {
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    protected void onInstruction(Instruction instruction) {
        Number[] args;
        long functionAddress;
        String mnemonic = instruction.getMnemonic();
        Object context = this.emulator.getContext();
        if ("bl".equals(mnemonic) || "blx".equals(mnemonic)) {
            OpInfo operands = (OpInfo)instruction.getOperands();
            Operand operand = operands.getOperands()[0];
            switch (operand.getType()) {
                case 2: {
                    functionAddress = operand.getValue().getImm();
                    break;
                }
                case 1: {
                    functionAddress = context.getIntByReg(instruction.mapToUnicornReg(operand.getValue().getReg()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("type=" + operand.getType());
                }
            }
            args = new Number[4];
            for (int i = 0; i < args.length; ++i) {
                args[i] = context.getIntArg(i);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.pushFunction(instruction.getAddress(), functionAddress, instruction.getAddress() + (long)instruction.getSize(), args);
    }
}

