/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.BlockHook;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.InterruptHook;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.debugger.BreakPoint;
import com.github.unidbg.debugger.BreakPointCallback;

public interface Backend {
    public void onInitialize();

    public void switchUserMode();

    public void enableVFP();

    public Number reg_read(int var1) throws BackendException;

    public byte[] reg_read_vector(int var1) throws BackendException;

    public void reg_write_vector(int var1, byte[] var2) throws BackendException;

    public void reg_write(int var1, Number var2) throws BackendException;

    public byte[] mem_read(long var1, long var3) throws BackendException;

    public void mem_write(long var1, byte[] var3) throws BackendException;

    public void mem_map(long var1, long var3, int var5) throws BackendException;

    public void mem_protect(long var1, long var3, int var5) throws BackendException;

    public void mem_unmap(long var1, long var3) throws BackendException;

    public BreakPoint addBreakPoint(long var1, BreakPointCallback var3, boolean var4);

    public boolean removeBreakPoint(long var1);

    public void setSingleStep(int var1);

    public void setFastDebug(boolean var1);

    public void hook_add_new(CodeHook var1, long var2, long var4, Object var6) throws BackendException;

    public void debugger_add(DebugHook var1, long var2, long var4, Object var6) throws BackendException;

    public void hook_add_new(ReadHook var1, long var2, long var4, Object var6) throws BackendException;

    public void hook_add_new(WriteHook var1, long var2, long var4, Object var6) throws BackendException;

    public void hook_add_new(EventMemHook var1, int var2, Object var3) throws BackendException;

    public void hook_add_new(InterruptHook var1, Object var2) throws BackendException;

    public void hook_add_new(BlockHook var1, long var2, long var4, Object var6) throws BackendException;

    public void emu_start(long var1, long var3, long var5, long var7) throws BackendException;

    public void emu_stop() throws BackendException;

    public void destroy() throws BackendException;

    public void context_restore(long var1);

    public void context_save(long var1);

    public long context_alloc();

    public void context_free(long var1);

    public int getPageSize();

    public void registerEmuCountHook(long var1);
}

