/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.backend.kvm.Kvm;
import com.github.unidbg.arm.backend.kvm.KvmBackend32;
import com.github.unidbg.arm.backend.kvm.KvmBackend64;
import java.io.IOException;
import org.scijava.nativelib.NativeLibraryUtil;
import org.scijava.nativelib.NativeLoader;

public class KvmFactory
extends BackendFactory {
    public KvmFactory(boolean fallbackUnicorn) {
        super(fallbackUnicorn);
    }

    @Override
    protected Backend newBackendInternal(Emulator<?> emulator, boolean is64Bit) {
        Kvm kvm = new Kvm(is64Bit);
        if (is64Bit) {
            return new KvmBackend64(emulator, kvm);
        }
        return new KvmBackend32(emulator, kvm);
    }

    static {
        try {
            if (NativeLibraryUtil.getArchitecture() == NativeLibraryUtil.Architecture.LINUX_ARM64) {
                NativeLoader.loadLibrary("kvm", new String[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

