/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.hypervisor;

import capstone.api.Disassembler;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.arm.backend.hypervisor.BreakRestorer;
import com.github.unidbg.arm.backend.hypervisor.Hypervisor;
import com.github.unidbg.arm.backend.hypervisor.arm64.SimpleMemorySizeDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HypervisorWatchpoint
implements BreakRestorer {
    private static final Log log = LogFactory.getLog(HypervisorWatchpoint.class);
    private final Object callback;
    private final long begin;
    private final long end;
    private final Object user_data;
    final int n;
    private final boolean isWrite;
    private final long dbgwcr;
    private final long dbgwvr;
    private final long bytes;

    HypervisorWatchpoint(Object callback2, long begin, long end, Object user_data, int n, boolean isWrite) {
        if (begin >= end) {
            throw new IllegalArgumentException("begin=0x" + Long.toHexString(begin) + ", end=" + Long.toHexString(end));
        }
        long size = end - begin;
        if (size >>> 31 != 0L) {
            throw new IllegalArgumentException("too large size=0x" + Long.toHexString(size));
        }
        this.callback = callback2;
        this.begin = begin;
        this.end = end;
        this.user_data = user_data;
        this.n = n;
        this.isWrite = isWrite;
        long dbgwcr = 5L;
        dbgwcr = isWrite ? (dbgwcr |= 0x10L) : (dbgwcr |= 8L);
        for (int i = 2; i <= 31; ++i) {
            long bas;
            int maskBits;
            int bytes = 1 << i;
            int mask = bytes - 1;
            long dbgwvr = begin & (long)(~mask);
            long offset = begin - dbgwvr;
            if (offset + size > (long)bytes) continue;
            if (i <= 3) {
                maskBits = 0;
                bas = 0L;
                for (long m = 0L; m < size; ++m) {
                    bas |= 1L << (int)(offset + m);
                }
            } else {
                maskBits = i;
                bas = 255L;
            }
            dbgwcr |= bas << 5;
            dbgwcr |= (long)(maskBits << 24);
            if (log.isDebugEnabled()) {
                log.debug("begin=0x" + Long.toHexString(begin) + ", end=0x" + Long.toHexString(end) + ", dbgwvr=0x" + Long.toHexString(dbgwvr) + ", dbgwcr=0x" + Long.toHexString(dbgwcr) + ", offset=" + offset + ", size=" + size + ", i=" + i);
            }
            this.bytes = bytes;
            this.dbgwvr = dbgwvr;
            this.dbgwcr = dbgwcr;
            return;
        }
        throw new UnsupportedOperationException("begin=0x" + Long.toHexString(begin) + ", end=0x" + Long.toHexString(end));
    }

    final boolean contains(long address, boolean isWrite) {
        if (isWrite ^ this.isWrite) {
            return false;
        }
        return address >= this.dbgwvr && address < this.dbgwvr + this.bytes;
    }

    final boolean onHit(Backend backend, long address, boolean isWrite, Disassembler disassembler, byte[] code, long pc) {
        SimpleMemorySizeDetector memorySizeDetector = new SimpleMemorySizeDetector();
        if (address >= this.begin && address <= this.end) {
            if (isWrite) {
                ((WriteHook)this.callback).hook(backend, address, 0, 0L, this.user_data);
            } else {
                int size = memorySizeDetector.detectReadSize(disassembler, code, pc);
                ((ReadHook)this.callback).hook(backend, address, size, this.user_data);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void install(Hypervisor hypervisor) {
        hypervisor.install_watchpoint(this.n, this.dbgwvr, this.dbgwcr);
    }
}

