/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.kvm;

import capstone.api.Disassembler;
import capstone.api.DisassemblerFactory;
import capstone.api.Instruction;
import capstone.api.arm64.OpInfo;
import capstone.api.arm64.OpValue;
import capstone.api.arm64.Operand;
import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.KvmBackend;
import com.github.unidbg.arm.backend.kvm.Kvm;
import com.github.unidbg.arm.backend.kvm.KvmException;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvmBackend64
extends KvmBackend {
    private static final Log log = LogFactory.getLog(KvmBackend64.class);
    private static final int EC_AA64_SVC = 21;
    private static final int EC_AA64_BKPT = 60;
    private static final long DARWIN_KERNEL_BASE = -549753782272L;
    private static final long _COMM_PAGE64_BASE_ADDRESS = -549753733120L;
    private Disassembler disassembler;

    public KvmBackend64(Emulator<?> emulator, Kvm kvm) throws BackendException {
        super(emulator, kvm);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        this.mem_map(0xF0000000L, this.getPageSize(), 5);
        ByteBuffer buffer = ByteBuffer.allocate(this.getPageSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            if (buffer.position() == 1024) {
                buffer.putInt(956302304);
            } else {
                buffer.putInt(956302305);
            }
            if (!buffer.hasRemaining()) continue;
            buffer.putInt(-694221856);
        }
        UnidbgPointer ptr = UnidbgPointer.pointer(this.emulator, 0xF0000000L);
        assert (ptr != null);
        ptr.write(buffer.array());
    }

    private synchronized Disassembler createDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = DisassemblerFactory.createArm64Disassembler();
            this.disassembler.setDetail(true);
        }
        return this.disassembler;
    }

    private boolean handleCommRead(long vaddr, long elr) {
        OpInfo opInfo;
        UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, vaddr);
        assert (pointer != null);
        UnidbgPointer pc = UnidbgPointer.pointer(this.emulator, elr);
        assert (pc != null);
        byte[] code = ((Pointer)pc).getByteArray(0L, 4);
        Instruction insn = this.createDisassembler().disasm(code, elr, 1L)[0];
        if (log.isDebugEnabled()) {
            log.debug("handleCommRead vaddr=0x" + Long.toHexString(vaddr) + ", elr=0x" + Long.toHexString(elr) + ", asm=" + insn);
        }
        if ((opInfo = (OpInfo)insn.getOperands()).isUpdateFlags() || opInfo.isWriteBack() || !insn.getMnemonic().startsWith("ldr") || vaddr < -549753733120L) {
            throw new UnsupportedOperationException();
        }
        Operand[] op = opInfo.getOperands();
        int offset = (int)(vaddr - -549753733120L);
        switch (offset) {
            case 56: 
            case 64: 
            case 88: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 0L);
                this.kvm.reg_set_elr_el1(elr + 4L);
                return true;
            }
            case 72: 
            case 76: 
            case 80: 
            case 96: 
            case 100: 
            case 144: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 0);
                this.kvm.reg_set_elr_el1(elr + 4L);
                return true;
            }
            case 34: 
            case 52: 
            case 53: 
            case 54: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 1);
                this.kvm.reg_set_elr_el1(elr + 4L);
                return true;
            }
        }
        throw new UnsupportedOperationException("vaddr=0x" + Long.toHexString(vaddr));
    }

    @Override
    public boolean handleException(long esr, long far, long elr, long spsr, long pc) {
        int ec = (int)(esr >> 26 & 0x3FL);
        if (log.isDebugEnabled()) {
            log.debug("handleException syndrome=0x" + Long.toHexString(esr) + ", far=0x" + Long.toHexString(far) + ", elr=0x" + Long.toHexString(elr) + ", ec=0x" + Integer.toHexString(ec) + ", pc=0x" + Long.toHexString(pc));
        }
        switch (ec) {
            case 21: {
                int swi = (int)(esr & 0xFFFFL);
                this.callSVC(elr, swi);
                return true;
            }
            case 60: {
                int bkpt = (int)(esr & 0xFFFFL);
                this.interruptHookNotifier.notifyCallSVC(this, 7, bkpt);
                return true;
            }
            case 36: {
                boolean isv = (esr & 0x1000000L) != 0L;
                boolean isWrite = (esr >> 6 & 1L) != 0L;
                boolean s1ptw = (esr >> 7 & 1L) != 0L;
                int sas = (int)(esr >> 22 & 3L);
                int len = 1 << sas;
                int srt = (int)(esr >> 16 & 0x1FL);
                int dfsc = (int)(esr & 0x3FL);
                if (log.isDebugEnabled()) {
                    log.debug("handle EC_DATAABORT isv=" + isv + ", isWrite=" + isWrite + ", s1ptw=" + s1ptw + ", len=" + len + ", srt=" + srt + ", dfsc=0x" + Integer.toHexString(dfsc) + ", vaddr=0x" + Long.toHexString(far));
                }
                if (dfsc == 0 && this.emulator.getFamily() == Family.iOS) {
                    return this.handleCommRead(far, elr);
                }
                throw new UnsupportedOperationException("handleException ec=0x" + Integer.toHexString(ec) + ", dfsc=0x" + Integer.toHexString(dfsc));
            }
        }
        throw new UnsupportedOperationException("handleException ec=0x" + Integer.toHexString(ec));
    }

    @Override
    public void mem_map(long address, long size, int perms) throws BackendException {
        if (address == -549753782272L) {
            throw new BackendException();
        }
        super.mem_map(address, size, perms);
    }

    @Override
    public void switchUserMode() {
    }

    @Override
    public void enableVFP() {
        long value = this.reg_read(261).longValue();
        this.reg_write(261, value |= 0x300000L);
    }

    @Override
    public Number reg_read(int regId) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    return this.kvm.reg_read64(regId - 199);
                }
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: {
                    return (int)(this.kvm.reg_read64(regId - 168) & 0xFFFFFFFFL);
                }
                case 261: {
                    return this.kvm.reg_read_cpacr_el1();
                }
                case 4: {
                    return this.kvm.reg_read_sp64();
                }
                case 260: {
                    return this.kvm.reg_read_pc64();
                }
                case 1: {
                    return this.kvm.reg_read64(29);
                }
                case 2: {
                    return this.kvm.reg_read64(30);
                }
                case 3: {
                    return this.kvm.reg_read_nzcv();
                }
            }
            throw new KvmException("regId=" + regId);
        }
        catch (KvmException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void reg_write(int regId, Number value) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.kvm.reg_write64(regId - 199, value.longValue());
                    break;
                }
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: {
                    this.kvm.reg_write64(regId - 168, value.longValue());
                    break;
                }
                case 261: {
                    this.kvm.reg_set_cpacr_el1(value.longValue());
                    break;
                }
                case 4: {
                    this.kvm.reg_set_sp64(value.longValue());
                    break;
                }
                case 262: {
                    this.kvm.reg_set_tpidr_el0(value.longValue());
                    break;
                }
                case 2: {
                    this.kvm.reg_write64(30, value.longValue());
                    break;
                }
                case 263: {
                    this.kvm.reg_set_tpidrro_el0(value.longValue());
                    break;
                }
                case 3: {
                    this.kvm.reg_set_nzcv(value.longValue());
                    break;
                }
                default: {
                    throw new KvmException("regId=" + regId);
                }
            }
        }
        catch (KvmException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public byte[] reg_read_vector(int regId) throws BackendException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void debugger_add(DebugHook callback2, long begin, long end, Object user_data) throws BackendException {
    }

    @Override
    protected byte[] addSoftBreakPoint(long address, int svcNumber, boolean thumb) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
            KeystoneEncoded encoded = keystone.assemble("brk #" + svcNumber);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }

    @Override
    public synchronized void destroy() throws BackendException {
        super.destroy();
        IOUtils.close(this.disassembler);
        this.disassembler = null;
    }
}

