/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.AbstractARMDebugger;
import com.github.unidbg.debugger.DebugRunnable;
import com.github.unidbg.debugger.DebugServer;
import com.github.unidbg.utils.Inspector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Semaphore;
import keystone.Keystone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDebugServer
extends AbstractARMDebugger
implements DebugServer {
    private static final Log log = LogFactory.getLog(AbstractDebugServer.class);
    private final List<ByteBuffer> pendingWrites = new LinkedList<ByteBuffer>();
    private Selector selector;
    private ServerSocketChannel serverSocketChannel;
    private SocketChannel socketChannel;
    private final ByteBuffer input = ByteBuffer.allocate(1024);
    private boolean serverShutdown;
    private boolean closeConnection;
    private boolean serverRunning;
    private Semaphore semaphore;

    public AbstractDebugServer(Emulator<?> emulator) {
        super(emulator);
        this.setSingleStep(1);
        Thread thread = new Thread((Runnable)this, "dbgserver");
        thread.start();
    }

    protected final boolean isDebuggerConnected() {
        return this.socketChannel != null;
    }

    @Override
    public final void run() {
        this.runServer();
    }

    private void runServer() {
        this.selector = null;
        this.serverSocketChannel = null;
        this.socketChannel = null;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.socket().bind(new InetSocketAddress(23946));
            this.selector = Selector.open();
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.serverShutdown = false;
        this.serverRunning = true;
        System.err.println("Start " + this + " server on port: " + 23946);
        this.onServerStart();
        while (this.serverRunning) {
            try {
                int count = this.selector.select(50L);
                if (count <= 0) {
                    if (this.isDebuggerConnected() || System.in.available() <= 0) continue;
                    String line = new Scanner(System.in).nextLine();
                    if ("c".equals(line)) {
                        this.serverRunning = false;
                        break;
                    }
                    System.out.println("c: continue");
                    continue;
                }
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    if (key.isValid()) {
                        if (key.isAcceptable()) {
                            this.onSelectAccept(key);
                        }
                        if (key.isReadable()) {
                            this.onSelectRead(key);
                        }
                        if (key.isWritable()) {
                            this.onSelectWrite(key);
                        }
                    }
                    selectedKeys.remove();
                }
                this.processInput(this.input);
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("run server ex", e);
            }
        }
        IOUtils.close(this.serverSocketChannel);
        this.serverSocketChannel = null;
        IOUtils.close(this.selector);
        this.selector = null;
        this.closeSocketChannel();
        this.resumeRun();
    }

    protected abstract void onServerStart();

    protected abstract void processInput(ByteBuffer var1);

    private void enableNewConnections(boolean enable) {
        if (this.serverSocketChannel == null) {
            return;
        }
        SelectionKey key = this.serverSocketChannel.keyFor(this.selector);
        key.interestOps(enable ? 16 : 0);
    }

    private void onSelectAccept(SelectionKey key) throws IOException {
        ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
        SocketChannel sc = ssc.accept();
        if (sc != null) {
            this.closeConnection = false;
            this.pendingWrites.clear();
            this.input.clear();
            sc.configureBlocking(false);
            sc.register(key.selector(), 1);
            this.socketChannel = sc;
            this.enableNewConnections(false);
            this.onDebuggerConnected();
        }
    }

    protected abstract void onDebuggerConnected();

    private void onSelectWrite(SelectionKey key) throws IOException {
        SocketChannel sc = (SocketChannel)key.channel();
        if (this.pendingWrites.isEmpty() && this.closeConnection) {
            this.closeSocketChannel();
            return;
        }
        while (!this.pendingWrites.isEmpty()) {
            ByteBuffer bb = this.pendingWrites.get(0);
            try {
                sc.write(bb);
            }
            catch (IOException ex) {
                this.closeSocketChannel();
                throw ex;
            }
            if (bb.remaining() > 0) break;
            this.pendingWrites.remove(0);
        }
        if (this.pendingWrites.isEmpty() && !this.closeConnection) {
            this.enableWrites(false);
        }
    }

    private void onSelectRead(SelectionKey key) {
        int numRead;
        SocketChannel sc = (SocketChannel)key.channel();
        try {
            numRead = sc.read(this.input);
        }
        catch (IOException ex) {
            numRead = -1;
        }
        if (numRead == -1) {
            this.closeSocketChannel();
        }
    }

    private void closeSocketChannel() {
        if (this.socketChannel == null) {
            return;
        }
        SelectionKey key = this.socketChannel.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        IOUtils.close(this.socketChannel);
        this.socketChannel = null;
        if (!this.serverShutdown) {
            this.enableNewConnections(true);
        } else {
            this.serverRunning = false;
        }
    }

    private void enableWrites(boolean enable) {
        if (this.socketChannel == null) {
            return;
        }
        SelectionKey key = this.socketChannel.keyFor(this.selector);
        key.interestOps(enable ? 4 : 1);
    }

    protected final void sendData(byte[] data2) {
        if (log.isDebugEnabled()) {
            log.debug(Inspector.inspectString(data2, "sendData"));
        }
        ByteBuffer bb = ByteBuffer.wrap(data2);
        this.pendingWrites.add(bb);
        this.enableWrites(true);
    }

    @Override
    protected final void loop(Emulator<?> emulator, long address, int size, DebugRunnable<?> runnable) throws Exception {
        if (address <= 0L) {
            return;
        }
        this.semaphore = new Semaphore(0);
        this.onHitBreakPoint(emulator, address);
        this.semaphore.acquire();
    }

    @Override
    public <T> T run(DebugRunnable<T> runnable) {
        throw new UnsupportedOperationException();
    }

    protected abstract void onHitBreakPoint(Emulator<?> var1, long var2);

    public final void resumeRun() {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public final void singleStep() {
        this.setSingleStep(1);
        this.resumeRun();
    }

    @Override
    public final void close() {
        super.close();
        if (this.onDebuggerExit()) {
            this.shutdownServer();
        }
    }

    protected abstract boolean onDebuggerExit();

    public final void shutdownServer() {
        this.serverShutdown = true;
        this.closeConnection = true;
        this.enableWrites(true);
    }

    public final void detachServer() {
        this.closeConnection = true;
        this.enableWrites(true);
    }

    @Override
    protected Keystone createKeystone(boolean isThumb) {
        throw new UnsupportedOperationException();
    }
}

