/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.ida;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.ModuleListener;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.Arm32RegisterContext;
import com.github.unidbg.arm.context.Arm64RegisterContext;
import com.github.unidbg.debugger.AbstractDebugServer;
import com.github.unidbg.debugger.ida.DebuggerEvent;
import com.github.unidbg.debugger.ida.Utils;
import com.github.unidbg.debugger.ida.event.AttachExecutableEvent;
import com.github.unidbg.debugger.ida.event.DetachEvent;
import com.github.unidbg.debugger.ida.event.LoadExecutableEvent;
import com.github.unidbg.debugger.ida.event.LoadModuleEvent;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.utils.Inspector;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidServer
extends AbstractDebugServer
implements ModuleListener {
    private static final Log log = LogFactory.getLog(AndroidServer.class);
    private final byte protocolVersion;
    private int processExitStatus;
    private static final int TERMINATE_PROCESS_STATUS = 9;
    private final Queue<DebuggerEvent> eventQueue = new LinkedBlockingQueue<DebuggerEvent>();

    public AndroidServer(Emulator<?> emulator, byte protocolVersion) {
        super(emulator);
        this.protocolVersion = protocolVersion;
        emulator.getMemory().addModuleListener(this);
    }

    private void notifyDebugEvent() {
        this.sendAck(1);
    }

    private void sendAck(byte ... bytes) {
        this.sendPacket(0, bytes);
    }

    private void sendPacket(int type, byte[] data2) {
        ByteBuffer buffer = ByteBuffer.allocate(data2.length + 5);
        buffer.putInt(data2.length);
        buffer.put((byte)type);
        buffer.put(data2);
        this.sendData(buffer.array());
    }

    private void sendProcessWillTerminated(int exitStatus) {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.put(Utils.pack_dd(2L));
        buffer.put(Utils.pack_dd(this.emulator.getPid()));
        buffer.put(Utils.pack_dd(this.emulator.getPid()));
        buffer.put(Utils.pack_dd(0L));
        buffer.put(Utils.pack_dd(1L));
        buffer.put(Utils.pack_dd(0L));
        buffer.put(Utils.pack_dd(exitStatus));
        this.sendPacket(4, Utils.flipBuffer(buffer));
    }

    @Override
    protected void onServerStart() {
    }

    @Override
    public void onLoaded(Emulator<?> emulator, Module module) {
        if (log.isDebugEnabled()) {
            log.debug("onLoaded module=" + module);
        }
    }

    @Override
    protected void processInput(ByteBuffer input) {
        input.flip();
        while (input.hasRemaining()) {
            int length = input.getInt();
            int type = input.get() & 0xFF;
            if (length > input.remaining()) {
                throw new IllegalStateException("processInput length=" + length + ", type=0x" + Integer.toHexString(type));
            }
            byte[] data2 = new byte[length];
            input.get(data2);
            this.processCommand(type, data2);
        }
        input.clear();
    }

    private void processCommand(int type, byte[] data2) {
        if (log.isDebugEnabled()) {
            log.debug(Inspector.inspectString(data2, "processCommand type=0x" + Integer.toHexString(type)));
        }
        if (type == 0 && data2.length == 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data2);
        switch (type) {
            case 0: {
                this.notifyDebugEvent();
                break;
            }
            case 5: {
                this.ackDebuggerEvent();
                break;
            }
            case 10: {
                long value = Utils.unpack_dd(buffer);
                long b = Utils.unpack_dd(buffer);
                if (log.isDebugEnabled()) {
                    log.debug("processCommand value=0x" + Long.toHexString(value) + ", b=" + b);
                }
                this.sendAck(5);
                break;
            }
            case 11: {
                this.notifyDebuggerDetached();
                break;
            }
            case 12: {
                this.requestRunningProcesses();
                break;
            }
            case 14: {
                this.requestTerminateProcess();
                break;
            }
            case 15: {
                this.requestAttach(buffer);
                break;
            }
            case 16: {
                this.requestDetach();
                break;
            }
            case 17: {
                this.syncDebuggerEvent(buffer);
                break;
            }
            case 18: {
                this.requestPauseProcess();
                break;
            }
            case 19: {
                this.requestSymbols(buffer);
                break;
            }
            case 20: {
                this.onDebuggerEvent(buffer);
                break;
            }
            case 24: {
                this.requestMemoryRegions(buffer);
                break;
            }
            case 25: {
                this.requestReadMemory(buffer);
                break;
            }
            case 27: {
                this.requestBreakPointAction(buffer);
                break;
            }
            case 31: {
                this.requestReadRegisters(buffer);
                break;
            }
            case 32: {
                this.requestResetProgramCounter(buffer);
                break;
            }
            case 34: {
                this.parseSignal(buffer);
                break;
            }
            default: {
                log.warn(Inspector.inspectString(data2, "Not handler command type=0x" + Integer.toHexString(type)));
                this.sendAck(new byte[0]);
            }
        }
    }

    private void requestResetProgramCounter(ByteBuffer buffer) {
        long tid = Utils.unpack_dd(buffer);
        long b1 = Utils.unpack_dd(buffer);
        long b2 = Utils.unpack_dd(buffer);
        long pc = Utils.unpack_dq(buffer);
        if (log.isDebugEnabled()) {
            log.debug("requestResetProgramCounter tid=" + tid + ", b1=" + b1 + ", b2=" + b2 + ", pc=0x" + Long.toHexString(pc));
        }
        this.notifyDebugEvent();
    }

    private void requestPauseProcess() {
        if (log.isDebugEnabled()) {
            log.debug("requestPauseProcess");
        }
        this.sendAck(new byte[0]);
    }

    private void ackDebuggerEvent() {
        if (log.isDebugEnabled()) {
            log.debug("ackDebuggerEvent");
        }
    }

    private void notifyDebuggerDetached() {
        if (log.isDebugEnabled()) {
            log.debug("notifyDebuggerDetached");
        }
        this.sendAck(new byte[0]);
        this.shutdownServer();
        if (this.processExitStatus != 0) {
            System.exit(this.processExitStatus);
        } else {
            this.resumeRun();
        }
    }

    private void requestBreakPointAction(ByteBuffer buffer) {
        long action = Utils.unpack_dd(buffer);
        if (action == 0L) {
            long b2 = Utils.unpack_dd(buffer);
            long address = Utils.unpack_dq(buffer);
            long size = Utils.unpack_dd(buffer);
            byte[] backup = new byte[(int)size];
            buffer.get(backup);
            long b3 = Utils.unpack_dd(buffer);
            long value = Utils.unpack_dq(buffer);
            if (log.isDebugEnabled()) {
                log.debug(Inspector.inspectString(backup, "requestBreakPointAction action=" + action + ", b2=" + b2 + ", address=0x" + Long.toHexString(address) + ", size=" + size + ", b3=" + b3 + ", value=0x" + Long.toHexString(value)));
            }
            this.removeBreakPoint(--address);
            ByteBuffer newBuf = ByteBuffer.allocate(16);
            newBuf.put(Utils.pack_dd(1L));
            newBuf.put(Utils.pack_dd(1L));
            newBuf.put(Utils.pack_dd(0L));
            this.sendAck(Utils.flipBuffer(newBuf));
        } else if (action == 1L) {
            long b2 = Utils.unpack_dd(buffer);
            long address = Utils.unpack_dq(buffer);
            long b3 = Utils.unpack_dd(buffer);
            long size = Utils.unpack_dd(buffer);
            long value = Utils.unpack_dq(buffer);
            if (log.isDebugEnabled()) {
                log.debug("requestBreakPointAction action=" + action + ", b2=" + b2 + ", address=0x" + Long.toHexString(address) + ", b3=" + b3 + ", size=" + size + ", value=0x" + Long.toHexString(value));
            }
            this.addBreakPoint(--address);
            ByteBuffer newBuf = ByteBuffer.allocate(16);
            newBuf.put(Utils.pack_dd(1L));
            newBuf.put(Utils.pack_dd(1L));
            newBuf.put(Utils.pack_dd(0L));
            Backend backend = this.emulator.getBackend();
            byte[] data2 = backend.mem_read(address & 0xFFFFFFFFFFFFFFFEL, size);
            newBuf.put(Utils.pack_dd(data2.length));
            newBuf.put(data2);
            this.sendAck(Utils.flipBuffer(newBuf));
        } else {
            throw new UnsupportedOperationException("action=" + action);
        }
    }

    private void requestTerminateProcess() {
        if (log.isDebugEnabled()) {
            log.debug("requestTerminateProcess");
        }
        this.notifyDebugEvent();
        this.sendProcessWillTerminated(9);
    }

    private void requestDetach() {
        if (log.isDebugEnabled()) {
            log.debug("requestDetach");
        }
        this.eventQueue.add(new DetachEvent());
        this.notifyDebugEvent();
    }

    private void requestMemoryRegions(ByteBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug("requestMemoryRegions buffer=" + buffer);
        }
        Memory memory = this.emulator.getMemory();
        Collection<Module> modules = memory.getLoadedModules();
        ArrayList<MemRegion> list = new ArrayList<MemRegion>(modules.size());
        for (Module module : modules) {
            list.addAll(module.getRegions());
        }
        SvcMemory svcMemory = this.emulator.getSvcMemory();
        list.add(MemRegion.create(svcMemory.getBase(), svcMemory.getSize(), 5, "[svc]"));
        list.add(MemRegion.create(memory.getStackBase() - (long)memory.getStackSize(), memory.getStackSize(), 3, "[stack]"));
        Collections.sort(list);
        ByteBuffer newBuf = ByteBuffer.allocate(256 * list.size());
        newBuf.put(Utils.pack_dd(5L));
        newBuf.put(Utils.pack_dd(list.size()));
        for (MemRegion region : list) {
            newBuf.put(Utils.pack_dq(1L));
            newBuf.put(Utils.pack_dq(region.begin + 1L));
            long size = region.end - region.begin;
            newBuf.put(Utils.pack_dq(size + 1L));
            int mask = 16;
            if ((region.perms & 1) != 0) {
                mask |= 4;
            }
            if ((region.perms & 2) != 0) {
                mask |= 2;
            }
            if ((region.perms & 4) != 0) {
                mask |= 1;
            }
            newBuf.put((byte)mask);
            Utils.writeCString(newBuf, region.getName());
            newBuf.put((byte)0);
        }
        this.sendAck(Utils.flipBuffer(newBuf));
    }

    private void requestReadRegisters(ByteBuffer buffer) {
        long tid = Utils.unpack_dd(buffer);
        long b = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("requestReadRegisters tid=0x" + Long.toHexString(tid) + ", b=" + b);
        }
        if (this.emulator.is32Bit()) {
            Arm32RegisterContext context = (Arm32RegisterContext)this.emulator.getContext();
            ByteBuffer newBuf = ByteBuffer.allocate(256);
            newBuf.put(Utils.pack_dd(1L));
            for (int value : Arrays.asList(context.getR0Int(), context.getR1Int(), context.getR2Int(), context.getR3Int(), context.getR4Int(), context.getR5Int(), context.getR6Int(), context.getR7Int(), context.getR8Int(), context.getR9Int(), context.getR10Int(), context.getIntByReg(77), context.getIntByReg(78), context.getIntByReg(12), context.getIntByReg(10), context.getIntByReg(11), context.getIntByReg(3))) {
                newBuf.put(Utils.pack_dd(1L));
                newBuf.put(Utils.pack_dq(((long)value & 0xFFFFFFFFL) + 1L));
            }
            this.sendAck(Utils.flipBuffer(newBuf));
        } else {
            Arm64RegisterContext context = (Arm64RegisterContext)this.emulator.getContext();
            ByteBuffer newBuf = ByteBuffer.allocate(512);
            newBuf.put(Utils.pack_dd(1L));
            for (int i = 0; i < 29; ++i) {
                int regId = 199 + i;
                newBuf.put(Utils.pack_dd(1L));
                newBuf.put(Utils.pack_dq(context.getLongByReg(regId) + 1L));
            }
            for (long value : Arrays.asList(context.getLongByReg(1), context.getLongByReg(2), context.getLongByReg(4), context.getLongByReg(260), context.getLongByReg(3))) {
                newBuf.put(Utils.pack_dd(1L));
                newBuf.put(Utils.pack_dq(value + 1L));
            }
            this.sendAck(Utils.flipBuffer(newBuf));
        }
    }

    private void requestSymbols(ByteBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug("requestSymbols buffer=" + buffer);
        }
        this.sendAck(new byte[0]);
    }

    private void requestReadMemory(ByteBuffer buffer) {
        long address = Utils.unpack_dq(buffer);
        long size = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("requestReadMemory address=0x" + Long.toHexString(address) + ", size=" + size);
        }
        try {
            Backend backend = this.emulator.getBackend();
            byte[] data2 = backend.mem_read(address - 1L, size);
            ByteBuffer newBuf = ByteBuffer.allocate(data2.length + 16);
            newBuf.put(Utils.pack_dd(size));
            newBuf.put(data2);
            this.sendAck(Utils.flipBuffer(newBuf));
        }
        catch (BackendException e) {
            if (log.isDebugEnabled()) {
                log.debug("read memory failed: address=0x" + Long.toHexString(address), e);
            }
            this.sendAck(new byte[0]);
        }
    }

    private void parseSignal(ByteBuffer buffer) {
        long size = Utils.unpack_dd(buffer);
        int i = 0;
        while ((long)i < size) {
            long index = Utils.unpack_dd(buffer);
            long mask = Utils.unpack_dd(buffer);
            String sig = Utils.readCString(buffer);
            String desc = Utils.readCString(buffer);
            if (log.isDebugEnabled()) {
                log.debug("signal index=" + index + ", mask=0x" + Long.toHexString(mask) + ", sig=" + sig + ", desc=" + desc);
            }
            ++i;
        }
        this.sendAck(new byte[0]);
    }

    private void syncDebuggerEvent(ByteBuffer buffer) {
        DebuggerEvent event;
        long b = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("syncDebuggerEvent b=" + b);
        }
        if ((event = this.eventQueue.poll()) == null) {
            this.sendAck(0);
        } else {
            byte[] packet = event.pack(this.emulator);
            this.sendAck(packet);
        }
    }

    private void onDebuggerEvent(ByteBuffer buffer) {
        int type = (int)Utils.unpack_dd(buffer);
        switch (type) {
            case 1: 
            case 1024: {
                this.notifyProcessEvent(buffer, type);
                break;
            }
            case 16: {
                this.notifyProcessSingleStep(buffer);
                break;
            }
            case 2: {
                this.notifyProcessExit(buffer);
                break;
            }
            case 128: {
                this.notifyLoadModule(buffer);
                break;
            }
            case 2048: {
                this.notifyProcessStatus(buffer);
                break;
            }
            default: {
                log.warn("onDebuggerEvent type=0x" + Integer.toHexString(type));
            }
        }
        this.notifyDebugEvent();
    }

    private void notifyProcessSingleStep(ByteBuffer buffer) {
        long pid = Utils.unpack_dd(buffer);
        long tid = Utils.unpack_dd(buffer);
        long pc = Utils.unpack_dq(buffer);
        if (log.isDebugEnabled()) {
            log.debug("notifyProcessSingleStep pid=" + pid + ", tid=" + tid + ", pc=0x" + Long.toHexString(pc));
        }
        this.resumeRun();
    }

    private void notifyProcessStatus(ByteBuffer buffer) {
        long pid = Utils.unpack_dd(buffer);
        long tid = Utils.unpack_dd(buffer);
        long b1 = Utils.unpack_dd(buffer);
        long b2 = Utils.unpack_dd(buffer);
        long b3 = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("notifyProcessStatus pid=" + pid + ", tid=" + tid + ", b1=" + b1 + ", b2=" + b2 + ", b3=" + b3);
        }
    }

    private void notifyProcessExit(ByteBuffer buffer) {
        long pid = Utils.unpack_dd(buffer);
        long tid = Utils.unpack_dd(buffer);
        long b1 = Utils.unpack_dd(buffer);
        long b2 = Utils.unpack_dd(buffer);
        long b3 = Utils.unpack_dd(buffer);
        long exitStatus = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("notifyProcessExit pid=" + pid + ", tid=" + tid + ", b1=" + b1 + ", b2=" + b2 + ", b3=" + b3 + ", exitStatus=" + exitStatus);
        }
        this.processExitStatus = (int)exitStatus;
    }

    private void notifyProcessEvent(ByteBuffer buffer, int type) {
        long pid = Utils.unpack_dd(buffer);
        long tid = Utils.unpack_dd(buffer);
        long pc = Utils.unpack_dq(buffer);
        long b2 = Utils.unpack_dd(buffer);
        String executable = Utils.readCString(buffer);
        long base = Utils.unpack_dq(buffer);
        long size = Utils.unpack_dq(buffer);
        long test = Utils.unpack_dq(buffer);
        if (log.isDebugEnabled()) {
            log.debug("notifyProcessEvent type=0x" + Integer.toHexString(type) + ", pid=" + pid + ", tid=" + tid + ", pc=0x" + Long.toHexString(pc) + ", b2=" + b2 + ", executable=" + executable + ", base=0x" + Long.toHexString(base) + ", size=0x" + Long.toHexString(size) + ", test=0x" + Long.toHexString(test));
        }
        if (type == 1024) {
            this.resumeRun();
        }
    }

    private void notifyLoadModule(ByteBuffer buffer) {
        long pid = Utils.unpack_dd(buffer);
        long tid = Utils.unpack_dd(buffer);
        long address = Utils.unpack_dq(buffer);
        long s1 = Utils.unpack_dd(buffer);
        String path = Utils.readCString(buffer);
        long base = Utils.unpack_dq(buffer);
        long size = Utils.unpack_dq(buffer);
        long l1 = Utils.unpack_dq(buffer);
        if (log.isDebugEnabled()) {
            log.debug("notifyLoadModule pid=" + pid + ", tid=" + tid + ", address=0x" + Long.toHexString(address) + ", s1=" + s1 + ", path=" + path + ", base=0x" + Long.toHexString(base) + ", size=0x" + Long.toHexString(size) + ", l1=0x" + Long.toHexString(l1));
        }
    }

    private void requestAttach(ByteBuffer buffer) {
        long pid = Utils.unpack_dd(buffer);
        int value = (int)Utils.unpack_dd(buffer);
        long b = Utils.unpack_dd(buffer);
        if (log.isDebugEnabled()) {
            log.debug("requestAttach pid=" + pid + ", value=" + value + ", b=" + b);
        }
        ArrayList<Module> modules = new ArrayList<Module>(this.emulator.getMemory().getLoadedModules());
        Collections.reverse(modules);
        for (Module module : modules) {
            this.eventQueue.offer(new LoadModuleEvent(module));
        }
        ByteBuffer newBuf = ByteBuffer.allocate(16);
        newBuf.put((byte)1);
        newBuf.put((byte)this.emulator.getPointerSize());
        Utils.writeCString(newBuf, "linux");
        this.sendAck(Utils.flipBuffer(newBuf));
        this.eventQueue.add(new LoadExecutableEvent());
        this.eventQueue.add(new AttachExecutableEvent());
    }

    private void requestRunningProcesses() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put((byte)1);
        buffer.put((byte)1);
        buffer.put(Utils.pack_dd(this.emulator.getPid()));
        Utils.writeCString(buffer, "[" + this.emulator.getPointerSize() * 8 + "] " + "unidbg");
        this.sendAck(Utils.flipBuffer(buffer));
    }

    @Override
    protected void onHitBreakPoint(Emulator<?> emulator, long address) {
        if (log.isDebugEnabled()) {
            log.debug("onHitBreakPoint address=0x" + Long.toHexString(address));
        }
        if (this.isDebuggerConnected()) {
            ByteBuffer buffer = ByteBuffer.allocate(32);
            buffer.put(Utils.pack_dd(16L));
            buffer.put(Utils.pack_dd(emulator.getPid()));
            buffer.put(Utils.pack_dd(emulator.getPid()));
            buffer.put(Utils.pack_dq(address + 1L));
            buffer.put(Utils.pack_dq(0L));
            if (emulator.is32Bit()) {
                buffer.put(Utils.pack_dd(1L));
                buffer.put(Utils.pack_dd(0L));
                buffer.put(Utils.pack_dd(1L));
            } else {
                buffer.put(Utils.pack_dd(0L));
                buffer.put(Utils.pack_dd(0L));
                buffer.put(Utils.pack_dd(0L));
            }
            this.sendPacket(4, Utils.flipBuffer(buffer));
        }
    }

    @Override
    protected boolean onDebuggerExit() {
        if (log.isDebugEnabled()) {
            log.debug("onDebuggerExit");
        }
        this.sendProcessWillTerminated(0);
        return false;
    }

    @Override
    protected void onDebuggerConnected() {
        this.sendPacket(3, new byte[]{this.protocolVersion, 11, (byte)this.emulator.getPointerSize()});
    }

    public String toString() {
        return "IDA android";
    }
}

