/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileIO
implements NewFileIO {
    private static final Log log = LogFactory.getLog(AbstractFileIO.class);
    private static final int F_GETFD = 1;
    private static final int F_SETFD = 2;
    private static final int F_GETFL = 3;
    private static final int F_SETFL = 4;
    private static final int F_SETLK = 6;
    private static final int F_SETLKW = 7;
    private static final int F_ADDFILESIGS = 61;
    private static final int FD_CLOEXEC = 1;
    protected int op;
    protected int oflags;
    protected boolean stdio;

    protected AbstractFileIO(int oflags) {
        this.oflags = oflags;
    }

    protected abstract void setFlags(long var1);

    @Override
    public int fcntl(Emulator<?> emulator, int cmd, long arg) {
        switch (cmd) {
            case 1: {
                return this.op;
            }
            case 2: {
                if (1L != arg) break;
                this.op |= 1;
                return 0;
            }
            case 3: {
                return this.oflags;
            }
            case 4: {
                this.setFlags(arg);
                return 0;
            }
            case 6: 
            case 7: 
            case 61: {
                return 0;
            }
        }
        throw new UnsupportedOperationException(this.getClass().getName() + ", cmd=" + cmd + ", arg=0x" + Long.toHexString(arg & 0xFFFFFFFFL) + ", this=" + this);
    }

    @Override
    public int ioctl(Emulator<?> emulator, long request, long argp) {
        if (log.isTraceEnabled()) {
            emulator.attach().debug();
        }
        throw new AbstractMethodError(this.getClass().getName() + ": request=0x" + Long.toHexString(request) + ", argp=0x" + Long.toHexString(argp));
    }

    @Override
    public int bind(Pointer addr, int addrlen) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public int listen(int backlog) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public int connect(Pointer addr, int addrlen) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public int setsockopt(int level, int optname, Pointer optval, int optlen) {
        throw new AbstractMethodError();
    }

    @Override
    public int getsockopt(int level, int optname, Pointer optval, Pointer optlen) {
        throw new AbstractMethodError(this.getClass().getName() + ": level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen);
    }

    @Override
    public int getsockname(Pointer addr, Pointer addrlen) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public int sendto(byte[] data2, int flags, Pointer dest_addr, int addrlen) {
        throw new AbstractMethodError(Inspector.inspectString(data2, "sendto flags=0x" + Integer.toHexString(flags) + ", dest_addr=" + dest_addr + ", addrlen=" + addrlen));
    }

    @Override
    public int recvfrom(Backend backend, Pointer buf, int len, int flags, Pointer src_addr, Pointer addrlen) {
        throw new AbstractMethodError(this.getClass().getName() + ": recvfrom buf=" + buf + ", len=" + len + ", flags=0x" + Integer.toHexString(flags) + ", src_addr=" + src_addr + ", addrlen=" + addrlen);
    }

    @Override
    public int lseek(int offset, int whence) {
        throw new AbstractMethodError("class=" + this.getClass() + ", offset=0x" + Long.toHexString(offset) + ", whence=" + whence + ", path=" + this.getPath());
    }

    @Override
    public int ftruncate(int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getpeername(Pointer addr, Pointer addrlen) {
        throw new AbstractMethodError();
    }

    @Override
    public int shutdown(int how) {
        throw new AbstractMethodError();
    }

    @Override
    public final long mmap2(Emulator<?> emulator, long addr, int aligned, int prot, int offset, int length) throws IOException {
        Backend backend = emulator.getBackend();
        byte[] data2 = this.getMmapData(addr, offset, length);
        backend.mem_map(addr, aligned, prot);
        emulator.getMemory().pointer(addr).write(data2);
        return addr;
    }

    protected byte[] getMmapData(long addr, int offset, int length) throws IOException {
        throw new AbstractMethodError(this.getClass().getName() + ", addr=0x" + Long.toHexString(addr) + ", offset=" + offset + ", length=" + length);
    }

    @Override
    public int llseek(long offset, Pointer result, int whence) {
        throw new AbstractMethodError();
    }

    @Override
    public void close() {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public int write(byte[] data2) {
        throw new UnsupportedOperationException(Inspector.inspectString(data2, this.getClass().getName()));
    }

    @Override
    public int read(Backend backend, Pointer buffer, int count) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int pread(Backend backend, Pointer buffer, int count, long offset) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public FileIO dup2() {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public String getPath() {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean isStdIO() {
        return this.stdio;
    }
}

