/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.hookzz;

import com.github.unidbg.Emulator;
import com.github.unidbg.hook.hookzz.HookZzArm64RegisterContext;
import com.github.unidbg.hook.hookzz.HookZzRegisterContext;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Stack;

public class HookZzArm64RegisterContextImpl
extends HookZzRegisterContext
implements HookZzArm64RegisterContext {
    private final Pointer reg_ctx;
    private final Emulator<?> emulator;

    HookZzArm64RegisterContextImpl(Emulator<?> emulator, Stack<Object> context) {
        super(context);
        this.reg_ctx = UnidbgPointer.register(emulator, 199).share(8L);
        this.emulator = emulator;
    }

    @Override
    public UnidbgPointer getPointerArg(int index) {
        if (index < 8) {
            return this.getXPointer(index);
        }
        UnidbgPointer sp = this.getStackPointer();
        return sp.getPointer((long)(index - 8) * (long)this.emulator.getPointerSize());
    }

    @Override
    public long getXLong(int index) {
        if (index >= 0 && index <= 28) {
            return this.reg_ctx.getLong(index * 8);
        }
        throw new IllegalArgumentException("invalid index: " + index);
    }

    @Override
    public int getXInt(int index) {
        return (int)this.getXLong(index);
    }

    @Override
    public UnidbgPointer getXPointer(int index) {
        return UnidbgPointer.pointer(this.emulator, this.getXLong(index));
    }

    @Override
    public long getFp() {
        return this.reg_ctx.getLong(232L);
    }

    @Override
    public void setXLong(int index, long value) {
        if (index < 0 || index > 28) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        this.reg_ctx.setLong(index * 8, value);
    }

    @Override
    public void setStackPointer(Pointer sp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnidbgPointer getFpPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getFp());
    }

    @Override
    public long getLR() {
        return this.reg_ctx.getLong(240L);
    }

    @Override
    public UnidbgPointer getLRPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getLR());
    }

    @Override
    public UnidbgPointer getStackPointer() {
        return (UnidbgPointer)this.reg_ctx.share(376L);
    }
}

