/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.InitFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AbsoluteInitFunction
extends InitFunction {
    private static final Log log = LogFactory.getLog(AbsoluteInitFunction.class);
    private final UnidbgPointer ptr;

    private static long getFuncAddress(UnidbgPointer ptr) {
        UnidbgPointer func = ptr.getPointer(0L);
        return func == null ? 0L : func.peer;
    }

    AbsoluteInitFunction(long load_base, String libName, UnidbgPointer ptr) {
        super(load_base, libName, AbsoluteInitFunction.getFuncAddress(ptr));
        this.ptr = ptr;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public long call(Emulator<?> emulator) {
        long address = AbsoluteInitFunction.getFuncAddress(this.ptr);
        if (address == 0L) {
            address = this.address;
        }
        if (emulator.is32Bit()) {
            address = (int)address;
        }
        if (address == 0L || address == -1L) {
            if (log.isDebugEnabled()) {
                log.debug("[" + this.libName + "]CallInitFunction: address=0x" + Long.toHexString(address) + ", ptr=" + this.ptr + ", func=" + this.ptr.getPointer(0L));
            }
            return address;
        }
        UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        if (log.isDebugEnabled()) {
            log.debug("[" + this.libName + "]CallInitFunction: " + pointer);
        }
        long start = System.currentTimeMillis();
        emulator.eFunc(address, new Number[0]);
        if (log.isDebugEnabled()) {
            System.err.println("[" + this.libName + "]CallInitFunction: " + pointer + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
        return address;
    }
}

