/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Alignment;
import com.github.unidbg.Emulator;
import com.github.unidbg.LibraryResolver;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.linux.AbsoluteInitFunction;
import com.github.unidbg.linux.LinuxInitFunction;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.linux.ModuleSymbol;
import com.github.unidbg.linux.android.ElfLibraryFile;
import com.github.unidbg.linux.thread.PThreadInternal;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryAllocBlock;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.memory.MemoryBlockImpl;
import com.github.unidbg.memory.MemoryMap;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.AbstractLoader;
import com.github.unidbg.spi.InitFunction;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.spi.Loader;
import com.github.unidbg.thread.Task;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.virtualmodule.VirtualSymbol;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fornwall.jelf.ArmExIdx;
import net.fornwall.jelf.ElfDynamicStructure;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfRelocation;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSegment;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolStructure;
import net.fornwall.jelf.GnuEhFrameHeader;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.PtLoadData;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidElfLoader
extends AbstractLoader<AndroidFileIO>
implements Memory,
Loader {
    private static final Log log = LogFactory.getLog(AndroidElfLoader.class);
    private Symbol malloc;
    private Symbol free;
    private final Map<String, LinuxModule> modules = new LinkedHashMap<String, LinuxModule>();
    private final UnidbgPointer environ;
    private static final int RTLD_DEFAULT = -1;
    private String maxSoName;
    private long maxSizeOfSo;
    private static final long HEAP_BASE = 0x8048000L;
    private long brk;
    private static final int MAP_FAILED = -1;
    public static final int MAP_FIXED = 16;
    public static final int MAP_ANONYMOUS = 32;
    private Pointer errno;
    private int lastErrno;

    public AndroidElfLoader(Emulator<AndroidFileIO> emulator, UnixSyscallHandler<AndroidFileIO> syscallHandler) {
        super(emulator, syscallHandler);
        this.stackSize = 256 * emulator.getPageAlign();
        this.backend.mem_map(0xC0000000L - (long)this.stackSize, this.stackSize, 3);
        this.setStackPoint(0xC0000000L);
        this.environ = this.initializeTLS(new String[]{"ANDROID_DATA=/data", "ANDROID_ROOT=/system", "PATH=/sbin:/vendor/bin:/system/sbin:/system/bin:/system/xbin", "NO_ADDR_COMPAT_LAYOUT_FIXUP=1"});
        this.setErrno(0);
    }

    @Override
    public void setLibraryResolver(LibraryResolver libraryResolver) {
        super.setLibraryResolver(libraryResolver);
        this.syscallHandler.open(this.emulator, "stdin", 0);
        this.syscallHandler.open(this.emulator, "stdout", 1);
        this.syscallHandler.open(this.emulator, "stderr", 1);
    }

    @Override
    protected LibraryFile createLibraryFile(File file) {
        return new ElfLibraryFile(file, this.emulator.is64Bit());
    }

    private UnidbgPointer initializeTLS(String[] envs) {
        UnidbgPointer thread = this.allocateStack(1024);
        PThreadInternal pThread = PThreadInternal.create(this.emulator, thread);
        pThread.tid = this.emulator.getPid();
        pThread.pack();
        UnidbgPointer __stack_chk_guard = this.allocateStack(this.emulator.getPointerSize());
        UnidbgPointer programName = this.writeStackString(this.emulator.getProcessName());
        UnidbgPointer programNamePointer = this.allocateStack(this.emulator.getPointerSize());
        assert (programNamePointer != null);
        ((Pointer)programNamePointer).setPointer(0L, programName);
        UnidbgPointer auxv = this.allocateStack(256);
        assert (auxv != null);
        int AT_RANDOM = 25;
        ((Pointer)auxv).setPointer(0L, UnidbgPointer.pointer(this.emulator, 25L));
        ((Pointer)auxv).setPointer(this.emulator.getPointerSize(), __stack_chk_guard);
        int AT_PAGESZ = 6;
        ((Pointer)auxv).setPointer((long)this.emulator.getPointerSize() * 2L, UnidbgPointer.pointer(this.emulator, 6L));
        ((Pointer)auxv).setPointer((long)this.emulator.getPointerSize() * 3L, UnidbgPointer.pointer(this.emulator, this.emulator.getPageAlign()));
        ArrayList<String> envList = new ArrayList<String>();
        for (String env : envs) {
            int index = env.indexOf(61);
            if (index == -1) continue;
            envList.add(env);
        }
        UnidbgPointer environ = this.allocateStack(this.emulator.getPointerSize() * (envList.size() + 1));
        assert (environ != null);
        Pointer pointer = environ;
        for (String env : envList) {
            UnidbgPointer envPointer = this.writeStackString(env);
            ((Pointer)pointer).setPointer(0L, envPointer);
            pointer = pointer.share(this.emulator.getPointerSize());
        }
        ((Pointer)pointer).setPointer(0L, null);
        UnidbgPointer argv = this.allocateStack(256);
        assert (argv != null);
        argv.setPointer(this.emulator.getPointerSize(), programNamePointer);
        argv.setPointer(2L * (long)this.emulator.getPointerSize(), environ);
        argv.setPointer(3L * (long)this.emulator.getPointerSize(), auxv);
        UnidbgPointer tls = this.allocateStack(512);
        assert (tls != null);
        tls.setPointer(this.emulator.getPointerSize(), thread);
        this.errno = tls.share((long)this.emulator.getPointerSize() * 2L);
        tls.setPointer((long)this.emulator.getPointerSize() * 3L, argv);
        if (this.emulator.is32Bit()) {
            this.backend.reg_write(113, tls.peer);
        } else {
            this.backend.reg_write(262, tls.peer);
        }
        long sp = this.getStackPoint();
        this.setStackPoint(sp &= (long)(~(this.emulator.is64Bit() ? 15 : 7)));
        if (log.isDebugEnabled()) {
            log.debug("initializeTLS tls=" + tls + ", argv=" + argv + ", auxv=" + auxv + ", thread=" + thread + ", environ=" + environ + ", sp=0x" + Long.toHexString(this.getStackPoint()));
        }
        return argv.share(2L * (long)this.emulator.getPointerSize(), 0L);
    }

    @Override
    protected final LinuxModule loadInternal(LibraryFile libraryFile, boolean forceCallInit) {
        try {
            LinuxModule module = this.loadInternal(libraryFile);
            this.resolveSymbols(!forceCallInit);
            if (this.callInitFunction || forceCallInit) {
                for (LinuxModule m : this.modules.values().toArray(new LinuxModule[0])) {
                    boolean forceCall;
                    boolean bl = forceCall = forceCallInit && m == module || m.isForceCallInit();
                    if (this.callInitFunction) {
                        m.callInitFunction(this.emulator, forceCall);
                    } else if (forceCall) {
                        m.callInitFunction(this.emulator, true);
                    }
                    m.initFunctionList.clear();
                }
            }
            module.addReferenceCount();
            return module;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void resolveSymbols(boolean showWarning) throws IOException {
        Collection<LinuxModule> linuxModules = this.modules.values();
        for (LinuxModule m : linuxModules) {
            Iterator<ModuleSymbol> iterator = m.getUnresolvedSymbol().iterator();
            while (iterator.hasNext()) {
                ModuleSymbol moduleSymbol = iterator.next();
                ModuleSymbol resolved = moduleSymbol.resolve(new HashSet<Module>(linuxModules), true, this.hookListeners, this.emulator.getSvcMemory());
                if (resolved != null) {
                    log.debug("[" + moduleSymbol.soName + "]" + moduleSymbol.symbol.getName() + " symbol resolved to " + resolved.toSoName);
                    resolved.relocation(this.emulator, m);
                    iterator.remove();
                    continue;
                }
                if (!showWarning) continue;
                log.info("[" + moduleSymbol.soName + "]symbol " + moduleSymbol.symbol + " is missing relocationAddr=" + moduleSymbol.relocationAddr + ", offset=0x" + Long.toHexString(moduleSymbol.offset));
            }
        }
    }

    @Override
    public Module dlopen(String filename, boolean calInit) {
        LibraryFile file;
        LinuxModule loaded = this.modules.get(FilenameUtils.getName(filename));
        if (loaded != null) {
            loaded.addReferenceCount();
            return loaded;
        }
        for (Module module : this.getLoadedModules()) {
            for (MemRegion memRegion : module.getRegions()) {
                if (!filename.equals(memRegion.getName())) continue;
                module.addReferenceCount();
                return module;
            }
        }
        LibraryFile libraryFile = file = this.libraryResolver == null ? null : this.libraryResolver.resolveLibrary(this.emulator, filename);
        if (file == null) {
            return null;
        }
        if (calInit) {
            return this.loadInternal(file, false);
        }
        try {
            Module module;
            module = this.loadInternal(file);
            this.resolveSymbols(false);
            if (!this.callInitFunction) {
                for (LinuxModule m : this.modules.values()) {
                    m.initFunctionList.clear();
                }
            }
            module.addReferenceCount();
            return module;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Module dlopen(String filename) {
        return this.dlopen(filename, true);
    }

    @Override
    public Symbol dlsym(long handle, String symbolName) {
        Symbol symbol;
        if ("environ".equals(symbolName)) {
            return new VirtualSymbol(symbolName, null, this.environ.toUIntPeer());
        }
        Module sm = null;
        Symbol ret = null;
        for (LinuxModule linuxModule : this.modules.values()) {
            if (linuxModule.base != handle || (symbol = linuxModule.findSymbolByName(symbolName, false)) == null) continue;
            ret = symbol;
            sm = linuxModule;
            break;
        }
        if (ret == null && ((int)handle == -1 || handle == 0L)) {
            for (Module module : this.modules.values()) {
                symbol = module.findSymbolByName(symbolName, false);
                if (symbol == null) continue;
                ret = symbol;
                sm = module;
                break;
            }
        }
        for (HookListener hookListener : this.hookListeners) {
            long hook = hookListener.hook(this.emulator.getSvcMemory(), sm == null ? null : sm.name, symbolName, ret == null ? 0L : ret.getAddress());
            if (hook == 0L) continue;
            return new VirtualSymbol(symbolName, null, hook);
        }
        return ret;
    }

    @Override
    public boolean dlclose(long handle) {
        Iterator<Map.Entry<String, LinuxModule>> iterator = this.modules.entrySet().iterator();
        while (iterator.hasNext()) {
            LinuxModule module = iterator.next().getValue();
            if (module.base != handle) continue;
            if (module.decrementReferenceCount() <= 0) {
                module.unload(this.backend);
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private LinuxModule loadInternal(LibraryFile libraryFile) throws IOException {
        ElfSymbolStructure dynsym;
        int count;
        boolean executable;
        ElfFile elfFile = ElfFile.fromBuffer(libraryFile.mapBuffer());
        if (this.emulator.is32Bit() && elfFile.objectSize != 1) {
            throw new ElfException("Must be 32-bit");
        }
        if (this.emulator.is64Bit() && elfFile.objectSize != 2) {
            throw new ElfException("Must be 64-bit");
        }
        if (elfFile.encoding != 1) {
            throw new ElfException("Must be LSB");
        }
        if (this.emulator.is32Bit() && elfFile.arch != 40) {
            throw new ElfException("Must be ARM arch.");
        }
        if (this.emulator.is64Bit() && elfFile.arch != 183) {
            throw new ElfException("Must be ARM64 arch.");
        }
        long start = System.currentTimeMillis();
        long bound_high = 0L;
        long align = 0L;
        for (int i = 0; i < elfFile.num_ph; ++i) {
            ElfSegment ph = elfFile.getProgramHeader(i);
            if (ph.type != 1 || ph.mem_size <= 0L) continue;
            long high = ph.virtual_address + ph.mem_size;
            if (bound_high < high) {
                bound_high = high;
            }
            if (ph.alignment <= align) continue;
            align = ph.alignment;
        }
        ElfDynamicStructure dynamicStructure = null;
        long baseAlign = Math.max((long)this.emulator.getPageAlign(), align);
        long load_base = ((this.mmapBaseAddress - 1L) / baseAlign + 1L) * baseAlign;
        long load_virtual_address = 0L;
        long size = ARM.align((long)0L, (long)bound_high, (long)baseAlign).size;
        this.setMMapBaseAddress(load_base + size);
        ArrayList<MemRegion> regions = new ArrayList<MemRegion>(5);
        MemoizedObject<ArmExIdx> armExIdx = null;
        MemoizedObject<GnuEhFrameHeader> ehFrameHeader = null;
        Alignment lastAlignment = null;
        block20: for (int i = 0; i < elfFile.num_ph; ++i) {
            ElfSegment ph = elfFile.getProgramHeader(i);
            switch (ph.type) {
                case 1: {
                    int prot = this.get_segment_protection(ph.flags);
                    if (prot == 0) {
                        prot = 7;
                    }
                    long begin = load_base + ph.virtual_address;
                    if (load_virtual_address == 0L) {
                        load_virtual_address = begin;
                    }
                    Alignment alignment = ARM.align(begin, ph.mem_size, Math.max((long)this.emulator.getPageAlign(), ph.alignment));
                    int regionSize = regions.size();
                    MemRegion last = regionSize == 0 ? null : (MemRegion)regions.get(regionSize - 1);
                    MemRegion overall = null;
                    if (last != null && alignment.address >= last.begin && alignment.address < last.end) {
                        overall = last;
                    }
                    if (overall != null) {
                        long overallSize = overall.end - alignment.address;
                        int perms = overall.perms | prot;
                        if (this.mMapListener != null) {
                            perms = this.mMapListener.onProtect(alignment.address, overallSize, perms);
                        }
                        this.backend.mem_protect(alignment.address, overallSize, perms);
                        if (ph.mem_size > overallSize) {
                            Alignment alignment2 = this.mem_map(begin + overallSize, ph.mem_size - overallSize, prot, libraryFile.getName(), Math.max((long)this.emulator.getPageAlign(), ph.alignment));
                            regions.add(new MemRegion(begin, alignment2.address, alignment2.address + alignment2.size, prot, libraryFile, ph.virtual_address));
                            if (lastAlignment != null && lastAlignment.begin + lastAlignment.dataSize > begin) {
                                throw new UnsupportedOperationException();
                            }
                            lastAlignment = alignment2;
                            lastAlignment.begin = begin;
                        }
                    } else {
                        Alignment alignment3 = this.mem_map(begin, ph.mem_size, prot, libraryFile.getName(), Math.max((long)this.emulator.getPageAlign(), ph.alignment));
                        regions.add(new MemRegion(begin, alignment3.address, alignment3.address + alignment3.size, prot, libraryFile, ph.virtual_address));
                        if (lastAlignment != null) {
                            long base = lastAlignment.address + lastAlignment.size;
                            long off = alignment3.address - base;
                            if (off < 0L) {
                                throw new IllegalStateException();
                            }
                            if (off > 0L) {
                                this.backend.mem_map(base, off, 0);
                                if (this.mMapListener != null) {
                                    this.mMapListener.onMap(base, off, 0);
                                }
                                if (this.memoryMap.put(base, new MemoryMap(base, (int)off, 0)) != null) {
                                    log.warn("mem_map replace exists memory map base=" + Long.toHexString(base));
                                }
                            }
                        }
                        lastAlignment = alignment3;
                        lastAlignment.begin = begin;
                    }
                    PtLoadData loadData = ph.getPtLoadData();
                    loadData.writeTo(this.pointer(begin));
                    if (lastAlignment == null) continue block20;
                    lastAlignment.dataSize = loadData.getDataSize();
                    continue block20;
                }
                case 2: {
                    dynamicStructure = ph.getDynamicStructure();
                    continue block20;
                }
                case 3: {
                    if (!log.isDebugEnabled()) continue block20;
                    log.debug("[" + libraryFile.getName() + "]interp=" + ph.getInterpreter());
                    continue block20;
                }
                case 1685382480: {
                    ehFrameHeader = ph.getEhFrameHeader();
                    continue block20;
                }
                case 0x70000001: {
                    armExIdx = ph.getARMExIdxData();
                    continue block20;
                }
                default: {
                    if (!log.isDebugEnabled()) continue block20;
                    log.debug("[" + libraryFile.getName() + "]segment type=0x" + Integer.toHexString(ph.type) + ", offset=0x" + Long.toHexString(ph.offset));
                }
            }
        }
        if (dynamicStructure == null) {
            throw new IllegalStateException("dynamicStructure is empty.");
        }
        String soName = dynamicStructure.getSOName(libraryFile.getName());
        HashMap<String, Module> neededLibraries = new HashMap<String, Module>();
        for (String neededLibrary : dynamicStructure.getNeededLibraries()) {
            void var27_31;
            LinuxModule loaded;
            if (log.isDebugEnabled()) {
                log.debug(soName + " need dependency " + neededLibrary);
            }
            if ((loaded = this.modules.get(neededLibrary)) != null) {
                loaded.addReferenceCount();
                neededLibraries.put(FilenameUtils.getBaseName(loaded.name), loaded);
                continue;
            }
            LibraryFile libraryFile2 = libraryFile.resolveLibrary(this.emulator, neededLibrary);
            if (this.libraryResolver != null && libraryFile2 == null) {
                LibraryFile libraryFile3 = this.libraryResolver.resolveLibrary(this.emulator, neededLibrary);
            }
            if (var27_31 != null) {
                LinuxModule needed = this.loadInternal((LibraryFile)var27_31);
                needed.addReferenceCount();
                neededLibraries.put(FilenameUtils.getBaseName(needed.name), needed);
                continue;
            }
            log.info(soName + " load dependency " + neededLibrary + " failed");
        }
        for (LinuxModule module : this.modules.values()) {
            Iterator<Object> iterator = module.getUnresolvedSymbol().iterator();
            while (iterator.hasNext()) {
                ModuleSymbol moduleSymbol = iterator.next();
                ModuleSymbol resolved = moduleSymbol.resolve(module.getNeededLibraries(), false, this.hookListeners, this.emulator.getSvcMemory());
                if (resolved == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[" + moduleSymbol.soName + "]" + moduleSymbol.symbol.getName() + " symbol resolved to " + resolved.toSoName);
                }
                resolved.relocation(this.emulator, module);
                iterator.remove();
            }
        }
        ArrayList<ModuleSymbol> list = new ArrayList<ModuleSymbol>();
        ArrayList<ModuleSymbol> resolvedSymbols = new ArrayList<ModuleSymbol>();
        block24: for (MemoizedObject memoizedObject : dynamicStructure.getRelocations()) {
            ElfRelocation relocation = (ElfRelocation)memoizedObject.getValue();
            int type = relocation.type();
            if (type == 0) {
                log.warn("Unhandled relocation type " + type);
                continue;
            }
            ElfSymbol symbol = relocation.sym() == 0 ? null : relocation.symbol();
            long sym_value = symbol != null ? symbol.value : 0L;
            UnidbgPointer relocationAddr = UnidbgPointer.pointer(this.emulator, load_base + relocation.offset());
            assert (relocationAddr != null);
            Log log = LogFactory.getLog("com.github.unidbg.linux." + soName);
            if (log.isDebugEnabled()) {
                log.debug("symbol=" + symbol + ", type=" + type + ", relocationAddr=" + relocationAddr + ", offset=0x" + Long.toHexString(relocation.offset()) + ", addend=" + relocation.addend() + ", sym=" + relocation.sym() + ", android=" + relocation.isAndroid());
            }
            switch (type) {
                case 2: {
                    int offset = ((Pointer)relocationAddr).getInt(0L);
                    ModuleSymbol moduleSymbol = this.resolveSymbol(load_base, symbol, relocationAddr, soName, neededLibraries.values(), offset);
                    if (moduleSymbol == null) {
                        list.add(new ModuleSymbol(soName, load_base, symbol, relocationAddr, null, offset));
                        continue block24;
                    }
                    resolvedSymbols.add(moduleSymbol);
                    continue block24;
                }
                case 257: {
                    long offset = ((Pointer)relocationAddr).getLong(0L) + relocation.addend();
                    ModuleSymbol moduleSymbol = this.resolveSymbol(load_base, symbol, relocationAddr, soName, neededLibraries.values(), offset);
                    if (moduleSymbol == null) {
                        list.add(new ModuleSymbol(soName, load_base, symbol, relocationAddr, null, offset));
                        continue block24;
                    }
                    resolvedSymbols.add(moduleSymbol);
                    continue block24;
                }
                case 23: {
                    int offset = ((Pointer)relocationAddr).getInt(0L);
                    if (sym_value == 0L) {
                        ((Pointer)relocationAddr).setInt(0L, (int)load_base + offset);
                        continue block24;
                    }
                    throw new IllegalStateException("sym_value=0x" + Long.toHexString(sym_value));
                }
                case 1027: {
                    if (sym_value == 0L) {
                        ((Pointer)relocationAddr).setLong(0L, load_base + relocation.addend());
                        continue block24;
                    }
                    throw new IllegalStateException("sym_value=0x" + Long.toHexString(sym_value));
                }
                case 21: 
                case 22: {
                    ModuleSymbol moduleSymbol = this.resolveSymbol(load_base, symbol, relocationAddr, soName, neededLibraries.values(), 0L);
                    if (moduleSymbol == null) {
                        list.add(new ModuleSymbol(soName, load_base, symbol, relocationAddr, null, 0L));
                        continue block24;
                    }
                    resolvedSymbols.add(moduleSymbol);
                    continue block24;
                }
                case 1025: 
                case 1026: {
                    ModuleSymbol moduleSymbol = this.resolveSymbol(load_base, symbol, relocationAddr, soName, neededLibraries.values(), relocation.addend());
                    if (moduleSymbol == null) {
                        list.add(new ModuleSymbol(soName, load_base, symbol, relocationAddr, null, relocation.addend()));
                        continue block24;
                    }
                    resolvedSymbols.add(moduleSymbol);
                    continue block24;
                }
                case 20: {
                    throw new IllegalStateException("R_ARM_COPY relocations are not supported");
                }
                case 1024: {
                    throw new IllegalStateException("R_AARCH64_COPY relocations are not supported");
                }
            }
            log.warn("[" + soName + "]Unhandled relocation type " + type + ", symbol=" + symbol + ", relocationAddr=" + relocationAddr + ", offset=0x" + Long.toHexString(relocation.offset()) + ", addend=" + relocation.addend() + ", android=" + relocation.isAndroid());
        }
        ArrayList<InitFunction> initFunctionList = new ArrayList<InitFunction>();
        int n = dynamicStructure.getPreInitArraySize();
        boolean bl = executable = elfFile.file_type == 2 || n > 0;
        if (executable && (count = n / this.emulator.getPointerSize()) > 0) {
            UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, load_base + dynamicStructure.getPreInitArrayOffset());
            if (pointer == null) {
                throw new IllegalStateException("DT_PREINIT_ARRAY is null");
            }
            for (int i = 0; i < count; ++i) {
                UnidbgPointer ptr = pointer.share((long)i * (long)this.emulator.getPointerSize(), 0L);
                initFunctionList.add(new AbsoluteInitFunction(load_base, soName, ptr));
            }
        }
        if (elfFile.file_type == 3) {
            int initArraySize;
            int count2;
            int init = dynamicStructure.getInit();
            if (init != 0) {
                initFunctionList.add(new LinuxInitFunction(load_base, soName, init));
            }
            if ((count2 = (initArraySize = dynamicStructure.getInitArraySize()) / this.emulator.getPointerSize()) > 0) {
                UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, load_base + dynamicStructure.getInitArrayOffset());
                if (pointer == null) {
                    throw new IllegalStateException("DT_INIT_ARRAY is null");
                }
                for (int i = 0; i < count2; ++i) {
                    UnidbgPointer ptr = pointer.share((long)i * (long)this.emulator.getPointerSize(), 0L);
                    initFunctionList.add(new AbsoluteInitFunction(load_base, soName, ptr));
                }
            }
        }
        if ((dynsym = dynamicStructure.getSymbolStructure()) == null) {
            throw new IllegalStateException("dynsym is null");
        }
        ElfSection symbolTableSection = null;
        try {
            symbolTableSection = elfFile.getSymbolTableSection();
        }
        catch (Throwable count2) {
            // empty catch block
        }
        if (load_virtual_address == 0L) {
            throw new IllegalStateException("load_virtual_address");
        }
        LinuxModule module = new LinuxModule(load_virtual_address, load_base, size, soName, dynsym, list, initFunctionList, neededLibraries, regions, armExIdx, ehFrameHeader, symbolTableSection, elfFile, dynamicStructure, libraryFile);
        for (ModuleSymbol symbol : resolvedSymbols) {
            symbol.relocation(this.emulator, module);
        }
        if (executable) {
            for (LinuxModule linuxModule : this.modules.values()) {
                for (Map.Entry<String, ModuleSymbol> entry : linuxModule.resolvedSymbols.entrySet()) {
                    ElfSymbol symbol = module.getELFSymbolByName(entry.getKey());
                    if (symbol == null || symbol.isUndef()) continue;
                    entry.getValue().relocation(this.emulator, module, symbol);
                }
                linuxModule.resolvedSymbols.clear();
            }
        }
        if ("libc.so".equals(soName)) {
            this.malloc = module.findSymbolByName("malloc", false);
            this.free = module.findSymbolByName("free", false);
        }
        this.modules.put(soName, module);
        if (this.maxSoName == null || soName.length() > this.maxSoName.length()) {
            this.maxSoName = soName;
        }
        if (bound_high > this.maxSizeOfSo) {
            this.maxSizeOfSo = bound_high;
        }
        module.setEntryPoint(elfFile.entry_point);
        log.debug("Load library " + soName + " offset=" + (System.currentTimeMillis() - start) + "ms, entry_point=0x" + Long.toHexString(elfFile.entry_point));
        this.notifyModuleLoaded(module);
        return module;
    }

    @Override
    public Module loadVirtualModule(String name, Map<String, UnidbgPointer> symbols) {
        LinuxModule module = LinuxModule.createVirtualModule(name, symbols, this.emulator);
        this.modules.put(name, module);
        if (this.maxSoName == null || name.length() > this.maxSoName.length()) {
            this.maxSoName = name;
        }
        return module;
    }

    private ModuleSymbol resolveSymbol(long load_base, ElfSymbol symbol, Pointer relocationAddr, String soName, Collection<Module> neededLibraries, long offset) throws IOException {
        if (symbol == null) {
            return new ModuleSymbol(soName, load_base, null, relocationAddr, soName, offset);
        }
        if (!symbol.isUndef()) {
            for (HookListener listener : this.hookListeners) {
                long hook = listener.hook(this.emulator.getSvcMemory(), soName, symbol.getName(), load_base + symbol.value + offset);
                if (hook <= 0L) continue;
                return new ModuleSymbol(soName, -1L, symbol, relocationAddr, soName, hook);
            }
            return new ModuleSymbol(soName, load_base, symbol, relocationAddr, soName, offset);
        }
        return new ModuleSymbol(soName, load_base, symbol, relocationAddr, null, offset).resolve(neededLibraries, false, this.hookListeners, this.emulator.getSvcMemory());
    }

    private int get_segment_protection(int flags) {
        int prot = 0;
        if ((flags & 4) != 0) {
            prot |= 1;
        }
        if ((flags & 2) != 0) {
            prot |= 2;
        }
        if ((flags & 1) != 0) {
            prot |= 4;
        }
        return prot;
    }

    @Override
    public MemoryBlock malloc(int length, boolean runtime) {
        if (runtime) {
            return MemoryBlockImpl.alloc(this, length);
        }
        return MemoryAllocBlock.malloc(this.emulator, this.malloc, this.free, length);
    }

    @Override
    public int brk(long address) {
        if (address == 0L) {
            this.brk = 0x8048000L;
            return (int)this.brk;
        }
        if (address % (long)this.emulator.getPageAlign() != 0L) {
            throw new UnsupportedOperationException();
        }
        if (address > this.brk) {
            this.backend.mem_map(this.brk, address - this.brk, 3);
            if (this.mMapListener != null) {
                this.mMapListener.onMap(this.brk, address - this.brk, 3);
            }
            this.brk = address;
        } else if (address < this.brk) {
            this.backend.mem_unmap(address, this.brk - address);
            if (this.mMapListener != null) {
                this.mMapListener.onUnmap(address, this.brk - address);
            }
            this.brk = address;
        }
        return (int)this.brk;
    }

    @Override
    public long mmap2(long start, int length, int prot, int flags, int fd, int offset) {
        FileIO file;
        boolean isAnonymous;
        int aligned = (int)ARM.alignSize(length, this.emulator.getPageAlign());
        boolean bl = isAnonymous = (flags & 0x20) != 0 || start == 0L && fd <= 0 && offset == 0;
        if ((flags & 0x10) != 0 && isAnonymous) {
            if (log.isDebugEnabled()) {
                log.debug("mmap2 MAP_FIXED start=0x" + Long.toHexString(start) + ", length=" + length + ", prot=" + prot);
            }
            this.munmap(start, length);
            this.backend.mem_map(start, aligned, prot);
            if (this.mMapListener != null) {
                this.mMapListener.onMap(start, aligned, prot);
            }
            if (this.memoryMap.put(start, new MemoryMap(start, aligned, prot)) != null) {
                log.warn("mmap2 replace exists memory map: start=" + Long.toHexString(start));
            }
            return start;
        }
        if (isAnonymous) {
            long addr = this.allocateMapAddress(0L, aligned);
            if (log.isDebugEnabled()) {
                log.debug("mmap2 addr=0x" + Long.toHexString(addr) + ", mmapBaseAddress=0x" + Long.toHexString(this.mmapBaseAddress) + ", start=" + start + ", fd=" + fd + ", offset=" + offset + ", aligned=" + aligned + ", LR=" + this.emulator.getContext().getLRPointer());
            }
            this.backend.mem_map(addr, aligned, prot);
            if (this.mMapListener != null) {
                this.mMapListener.onMap(start, aligned, prot);
            }
            if (this.memoryMap.put(addr, new MemoryMap(addr, aligned, prot)) != null) {
                log.warn("mmap2 replace exists memory map addr=" + Long.toHexString(addr));
            }
            return addr;
        }
        try {
            if (start == 0L && fd > 0 && (file = this.syscallHandler.getFileIO(fd)) != null) {
                long addr = this.allocateMapAddress(0L, aligned);
                if (log.isDebugEnabled()) {
                    log.debug("mmap2 addr=0x" + Long.toHexString(addr) + ", mmapBaseAddress=0x" + Long.toHexString(this.mmapBaseAddress));
                }
                long ret = file.mmap2(this.emulator, addr, aligned, prot, offset, length);
                if (this.mMapListener != null) {
                    this.mMapListener.onMap(addr, aligned, prot);
                }
                if (this.memoryMap.put(addr, new MemoryMap(addr, aligned, prot)) != null) {
                    log.warn("mmap2 replace exists memory map addr=0x" + Long.toHexString(addr));
                }
                return ret;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            if (fd > 0 && (file = this.syscallHandler.getFileIO(fd)) != null) {
                if ((start & (long)(this.emulator.getPageAlign() - 1)) != 0L) {
                    return -1L;
                }
                long end = start + (long)length;
                for (Map.Entry entry : this.memoryMap.entrySet()) {
                    MemoryMap map = (MemoryMap)entry.getValue();
                    if (Math.max(start, (Long)entry.getKey()) > Math.min(map.base + map.size, end)) continue;
                    return -1L;
                }
                if (log.isDebugEnabled()) {
                    log.debug("mmap2 start=0x" + Long.toHexString(start) + ", mmapBaseAddress=0x" + Long.toHexString(this.mmapBaseAddress) + ", flags=0x" + Integer.toHexString(flags) + ", length=0x" + Integer.toHexString(length));
                }
                long ret = file.mmap2(this.emulator, start, aligned, prot, offset, length);
                if (this.mMapListener != null) {
                    this.mMapListener.onMap(start, aligned, prot);
                }
                if (this.memoryMap.put(start, new MemoryMap(start, aligned, prot)) != null) {
                    log.warn("mmap2 replace exists memory map start=0x" + Long.toHexString(start));
                }
                return ret;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.emulator.attach().debug();
        throw new AbstractMethodError("mmap2 start=0x" + Long.toHexString(start) + ", length=" + length + ", prot=0x" + Integer.toHexString(prot) + ", flags=0x" + Integer.toHexString(flags) + ", fd=" + fd + ", offset=" + offset);
    }

    @Override
    public int getLastErrno() {
        return this.lastErrno;
    }

    @Override
    public void setErrno(int errno) {
        this.lastErrno = errno;
        Task task = (Task)this.emulator.get(Task.TASK_KEY);
        if (task != null && task.setErrno(this.emulator, errno)) {
            return;
        }
        this.errno.setInt(0L, errno);
    }

    @Override
    public String getMaxLengthLibraryName() {
        return this.maxSoName;
    }

    @Override
    public long getMaxSizeOfLibrary() {
        return this.maxSizeOfSo;
    }

    @Override
    public Collection<Module> getLoadedModules() {
        return new ArrayList<Module>(this.modules.values());
    }
}

