/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.Symbol;
import com.github.unidbg.linux.LinuxModule;
import java.io.IOException;
import net.fornwall.jelf.ElfSymbol;

public class LinuxSymbol
extends Symbol {
    private final LinuxModule module;
    private final ElfSymbol elfSymbol;

    LinuxSymbol(LinuxModule module, ElfSymbol elfSymbol) throws IOException {
        super(elfSymbol.getName());
        this.module = module;
        this.elfSymbol = elfSymbol;
    }

    @Override
    public boolean isUndef() {
        return this.elfSymbol.isUndef();
    }

    @Override
    public Number call(Emulator<?> emulator, Object ... args) {
        return this.module.callFunction(emulator, this.getValue(), args);
    }

    @Override
    public long getAddress() {
        return this.module.base + this.getValue();
    }

    @Override
    public long getValue() {
        return this.elfSymbol.value;
    }

    @Override
    public String getModuleName() {
        return this.module.name;
    }
}

