/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.fornwall.jelf.ElfSymbol;

public class ModuleSymbol {
    static final long WEAK_BASE = -1L;
    final String soName;
    private final long load_base;
    final ElfSymbol symbol;
    final Pointer relocationAddr;
    final String toSoName;
    final long offset;

    ModuleSymbol(String soName, long load_base, ElfSymbol symbol, Pointer relocationAddr, String toSoName, long offset) {
        this.soName = soName;
        this.load_base = load_base;
        this.symbol = symbol;
        this.relocationAddr = relocationAddr;
        this.toSoName = toSoName;
        this.offset = offset;
    }

    ModuleSymbol resolve(Collection<Module> modules, boolean resolveWeak, List<HookListener> listeners, SvcMemory svcMemory) throws IOException {
        String symbolName = this.symbol.getName();
        for (Module m : modules) {
            LinuxModule module = (LinuxModule)m;
            Long symbolHook = module.hookMap.get(symbolName);
            if (symbolHook != null) {
                return new ModuleSymbol(this.soName, -1L, this.symbol, this.relocationAddr, module.name, symbolHook);
            }
            ElfSymbol elfSymbol = module.getELFSymbolByName(symbolName);
            if (elfSymbol == null || elfSymbol.isUndef()) continue;
            switch (elfSymbol.getBinding()) {
                case 1: 
                case 2: {
                    for (HookListener listener : listeners) {
                        long hook = listener.hook(svcMemory, module.name, symbolName, module.base + elfSymbol.value + this.offset);
                        if (hook <= 0L) continue;
                        module.hookMap.put(symbolName, hook);
                        return new ModuleSymbol(this.soName, -1L, elfSymbol, this.relocationAddr, module.name, hook);
                    }
                    return new ModuleSymbol(this.soName, module.base, elfSymbol, this.relocationAddr, module.name, this.offset);
                }
            }
        }
        if (resolveWeak && this.symbol.getBinding() == 2) {
            return new ModuleSymbol(this.soName, -1L, this.symbol, this.relocationAddr, "0", 0L);
        }
        if (("dlopen".equals(symbolName) || "dlclose".equals(symbolName) || "dlsym".equals(symbolName) || "dlerror".equals(symbolName) || "dladdr".equals(symbolName) || "android_update_LD_LIBRARY_PATH".equals(symbolName) || "android_get_LD_LIBRARY_PATH".equals(symbolName) || "dl_iterate_phdr".equals(symbolName) || "android_dlopen_ext".equals(symbolName) || "android_set_application_target_sdk_version".equals(symbolName) || "android_get_application_target_sdk_version".equals(symbolName) || "android_init_namespaces".equals(symbolName) || "android_create_namespace".equals(symbolName) || "dlvsym".equals(symbolName) || "android_dlwarning".equals(symbolName) || "dl_unwind_find_exidx".equals(symbolName)) && resolveWeak) {
            for (HookListener listener : listeners) {
                long hook = listener.hook(svcMemory, "libdl.so", symbolName, this.offset);
                if (hook <= 0L) continue;
                return new ModuleSymbol(this.soName, -1L, this.symbol, this.relocationAddr, "libdl.so", hook);
            }
        }
        return null;
    }

    void relocation(Emulator<?> emulator, LinuxModule module, ElfSymbol symbol) {
        long value = this.load_base == -1L ? this.offset : module.base + (symbol == null ? 0L : symbol.value) + this.offset;
        this.relocationAddr.setPointer(0L, UnidbgPointer.pointer(emulator, value));
    }

    void relocation(Emulator<?> emulator, LinuxModule owner) throws IOException {
        if (this.symbol != null) {
            owner.resolvedSymbols.put(this.symbol.getName(), this);
        }
        long value = this.load_base == -1L ? this.offset : this.load_base + (this.symbol == null ? 0L : this.symbol.value) + this.offset;
        this.relocationAddr.setPointer(0L, UnidbgPointer.pointer(emulator, value));
    }

    public ElfSymbol getSymbol() {
        return this.symbol;
    }

    Pointer getRelocationAddr() {
        return this.relocationAddr;
    }
}

