/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Utils;
import com.github.unidbg.linux.android.AndroidResolver;
import com.github.unidbg.spi.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;

public class URLibraryFile
implements LibraryFile {
    private final URL url;
    private final String name;
    private final int sdk;
    private final boolean is64Bit;

    public URLibraryFile(URL url, String name, int sdk, boolean is64Bit) {
        this.url = url;
        this.name = name;
        this.sdk = sdk;
        this.is64Bit = is64Bit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMapRegionName() {
        return this.getPath();
    }

    @Override
    public LibraryFile resolveLibrary(Emulator<?> emulator, String soName) {
        if (this.sdk <= 0) {
            return null;
        }
        return AndroidResolver.resolveLibrary(emulator, soName, this.sdk);
    }

    @Override
    public ByteBuffer mapBuffer() throws IOException {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            return Utils.mapBuffer(new File(this.url.getPath()));
        }
        return ByteBuffer.wrap(IOUtils.toByteArray(this.url));
    }

    @Override
    public long getFileSize() {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            return new File(this.url.getPath()).length();
        }
        try {
            return IOUtils.toByteArray(this.url).length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getPath() {
        return "/system/" + (this.is64Bit ? "lib64/" : "lib/") + this.name;
    }
}

