/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Symbol;
import com.github.unidbg.hook.BaseHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.hook.xhook.IxHook;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XHookImpl
extends BaseHook
implements IxHook {
    private static final Log log = LogFactory.getLog(XHookImpl.class);
    private final Symbol xhook_register;
    private final Symbol xhook_refresh;

    public static IxHook getInstance(Emulator<?> emulator) {
        IxHook ixHook = (IxHook)emulator.get(XHookImpl.class.getName());
        if (ixHook == null) {
            ixHook = new XHookImpl(emulator);
            emulator.set(XHookImpl.class.getName(), ixHook);
        }
        return ixHook;
    }

    private XHookImpl(Emulator<?> emulator) {
        super(emulator, "libxhook");
        this.xhook_register = this.module.findSymbolByName("xhook_register", false);
        this.xhook_refresh = this.module.findSymbolByName("xhook_refresh", false);
        if (log.isDebugEnabled()) {
            log.debug("xhook_register=" + this.xhook_register + ", xhook_refresh=" + this.xhook_refresh);
        }
        if (this.xhook_register == null) {
            throw new IllegalStateException("xhook_register is null");
        }
        if (this.xhook_refresh == null) {
            throw new IllegalStateException("xhook_refresh is null");
        }
        Symbol xhook_enable_sigsegv_protection = this.module.findSymbolByName("xhook_enable_sigsegv_protection", false);
        if (xhook_enable_sigsegv_protection == null) {
            throw new IllegalStateException("xhook_enable_sigsegv_protection is null");
        }
        xhook_enable_sigsegv_protection.call(emulator, 0);
        Symbol xhook_enable_debug = this.module.findSymbolByName("xhook_enable_debug", false);
        if (xhook_enable_debug == null) {
            throw new IllegalStateException("xhook_enable_debug is null");
        }
        xhook_enable_debug.call(emulator, log.isDebugEnabled() ? 1 : 0);
    }

    @Override
    public void register(String pathname_regex_str, String symbol, ReplaceCallback callback2) {
        this.register(pathname_regex_str, symbol, callback2, false);
    }

    @Override
    public void register(String pathname_regex_str, String symbol, ReplaceCallback callback2, boolean enablePostCall) {
        UnidbgPointer old_func = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer new_func = this.createReplacePointer(callback2, old_func, enablePostCall);
        int ret = this.xhook_register.call(this.emulator, pathname_regex_str, symbol, new_func, old_func).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void refresh() {
        int ret = this.xhook_refresh.call(this.emulator, 0).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }
}

