/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.apk;

import com.github.unidbg.linux.android.dvm.apk.Apk;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.parser.ApkMetaTranslator;
import net.dongliu.apk.parser.parser.BinaryXmlParser;
import net.dongliu.apk.parser.parser.CertificateParser;
import net.dongliu.apk.parser.parser.CompositeXmlStreamer;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.parser.XmlTranslator;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

class ApkDir
implements Apk {
    private final File dir;
    private CertificateMeta[] signatures;
    private boolean manifestParsed;
    private String manifestXml;
    private ApkMeta apkMeta;

    ApkDir(File dir) {
        this.dir = dir;
    }

    @Override
    public long getVersionCode() {
        this.parseManifest();
        return this.apkMeta == null ? 0L : this.apkMeta.getVersionCode();
    }

    @Override
    public String getVersionName() {
        this.parseManifest();
        return this.apkMeta == null ? null : this.apkMeta.getVersionName();
    }

    @Override
    public String getManifestXml() {
        this.parseManifest();
        return this.manifestXml;
    }

    @Override
    public byte[] openAsset(String fileName) {
        return this.getFileData("assets/" + fileName);
    }

    @Override
    public byte[] getFileData(String path) {
        File file = new File(this.dir, path);
        if (file.canRead()) {
            try {
                return FileUtils.readFileToByteArray(file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public CertificateMeta[] getSignatures() {
        if (this.signatures == null) {
            try {
                this.parseCertificates();
            }
            catch (IOException | CertificateException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.signatures;
    }

    private List<CertificateFile> getAllCertificateData() throws IOException {
        ArrayList<CertificateFile> list = new ArrayList<CertificateFile>();
        this.scanCertificateFile(list, this.dir);
        return list;
    }

    private void scanCertificateFile(List<CertificateFile> list, File dir) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext;
                return pathname.isDirectory() || (ext = FilenameUtils.getExtension(pathname.getName())).equalsIgnoreCase("RSA") || ext.equalsIgnoreCase("DSA");
            }
        });
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanCertificateFile(list, file);
                    continue;
                }
                list.add(new CertificateFile(file.getPath(), FileUtils.readFileToByteArray(file)));
            }
        }
    }

    private void parseCertificates() throws IOException, CertificateException {
        ArrayList<ApkSigner> apkSigners = new ArrayList<ApkSigner>();
        for (CertificateFile file : this.getAllCertificateData()) {
            CertificateParser parser = CertificateParser.getInstance(file.getData());
            List<CertificateMeta> certificateMetas = parser.parse();
            apkSigners.add(new ApkSigner(file.getPath(), certificateMetas));
        }
        ArrayList<CertificateMeta> signatures = new ArrayList<CertificateMeta>(apkSigners.size());
        for (ApkSigner signer : apkSigners) {
            signatures.addAll(signer.getCertificateMetas());
        }
        this.signatures = signatures.toArray(new CertificateMeta[0]);
    }

    @Override
    public String getPackageName() {
        this.parseManifest();
        return this.apkMeta == null ? null : this.apkMeta.getPackageName();
    }

    @Override
    public File getParentFile() {
        return this.dir.getParentFile();
    }

    private void parseManifest() {
        if (this.manifestParsed) {
            return;
        }
        ResourceTable resourceTable = new ResourceTable();
        Locale preferredLocale = Locale.US;
        XmlTranslator xmlTranslator = new XmlTranslator();
        ApkMetaTranslator apkTranslator = new ApkMetaTranslator(resourceTable, preferredLocale);
        CompositeXmlStreamer xmlStreamer = new CompositeXmlStreamer(xmlTranslator, apkTranslator);
        byte[] data2 = this.getFileData("AndroidManifest.xml");
        if (data2 != null) {
            this.transBinaryXml(data2, xmlStreamer, resourceTable, preferredLocale);
            this.manifestXml = xmlTranslator.getXml();
            this.apkMeta = apkTranslator.getApkMeta();
            this.manifestParsed = true;
        }
    }

    private void transBinaryXml(byte[] data2, XmlStreamer xmlStreamer, ResourceTable resourceTable, Locale preferredLocale) {
        ByteBuffer buffer = ByteBuffer.wrap(data2);
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer, resourceTable);
        binaryXmlParser.setLocale(preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlStreamer);
        binaryXmlParser.parse();
    }

    private static class CertificateFile {
        private final String path;
        private final byte[] data;

        CertificateFile(String path, byte[] data2) {
            this.path = path;
            this.data = data2;
        }

        public String getPath() {
            return this.path;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

