/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.apk;

import com.github.unidbg.linux.android.dvm.apk.Apk;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.exception.ParserException;

class ApkFile
implements Apk {
    private final File apkFile;
    private ApkMeta apkMeta;
    private CertificateMeta[] signatures;

    ApkFile(File file) {
        this.apkFile = file;
    }

    @Override
    public long getVersionCode() {
        long l;
        if (this.apkMeta != null) {
            return this.apkMeta.getVersionCode();
        }
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            this.apkMeta = apkFile.getApkMeta();
            l = this.apkMeta.getVersionCode();
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return l;
    }

    @Override
    public String getVersionName() {
        String string;
        if (this.apkMeta != null) {
            return this.apkMeta.getVersionName();
        }
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            this.apkMeta = apkFile.getApkMeta();
            string = this.apkMeta.getVersionName();
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return string;
    }

    @Override
    public String getManifestXml() {
        String string;
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            string = apkFile.getManifestXml();
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return string;
    }

    @Override
    public byte[] openAsset(String fileName) {
        byte[] byArray;
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            byArray = apkFile.getFileData("assets/" + fileName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return byArray;
    }

    @Override
    public CertificateMeta[] getSignatures() {
        CertificateMeta[] certificateMetaArray;
        if (this.signatures != null) {
            return this.signatures;
        }
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            ArrayList<CertificateMeta> signatures = new ArrayList<CertificateMeta>(10);
            for (ApkSigner signer : apkFile.getApkSingers()) {
                signatures.addAll(signer.getCertificateMetas());
            }
            this.signatures = signatures.toArray(new CertificateMeta[0]);
            certificateMetaArray = this.signatures;
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return certificateMetaArray;
    }

    @Override
    public String getPackageName() {
        String string;
        if (this.apkMeta != null) {
            return this.apkMeta.getPackageName();
        }
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            this.apkMeta = apkFile.getApkMeta();
            string = this.apkMeta.getPackageName();
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserException e) {
                return null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return string;
    }

    @Override
    public File getParentFile() {
        return this.apkFile.getParentFile();
    }

    @Override
    public byte[] getFileData(String path) {
        byte[] byArray;
        net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);
        try {
            byArray = apkFile.getFileData(path);
        }
        catch (Throwable throwable) {
            try {
                try {
                    apkFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        apkFile.close();
        return byArray;
    }
}

