/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.array;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.array.BaseArray;
import com.github.unidbg.linux.android.dvm.array.PrimitiveArray;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class FloatArray
extends BaseArray<float[]>
implements PrimitiveArray<float[]> {
    public FloatArray(VM vm, float[] value) {
        super(vm.resolveClass("[F", new DvmClass[0]), value);
    }

    @Override
    public int length() {
        return ((float[])this.value).length;
    }

    public void setValue(float[] value) {
        this.value = value;
    }

    @Override
    public void setData(int start, float[] data2) {
        System.arraycopy(data2, 0, this.value, start, data2.length);
    }

    @Override
    public UnidbgPointer _GetArrayCritical(Emulator<?> emulator, Pointer isCopy) {
        if (isCopy != null) {
            isCopy.setInt(0L, 1);
        }
        UnidbgPointer pointer = this.allocateMemoryBlock(emulator, ((float[])this.value).length * 4);
        pointer.write(0L, (float[])this.value, 0, ((float[])this.value).length);
        return pointer;
    }

    @Override
    public void _ReleaseArrayCritical(Pointer elems, int mode) {
        switch (mode) {
            case 1: {
                this.setValue(elems.getFloatArray(0L, ((float[])this.value).length));
                break;
            }
            case 0: {
                this.setValue(elems.getFloatArray(0L, ((float[])this.value).length));
            }
            case 2: {
                this.freeMemoryBlock(elems);
            }
        }
    }
}

