/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.array;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.array.BaseArray;
import com.github.unidbg.linux.android.dvm.array.PrimitiveArray;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class IntArray
extends BaseArray<int[]>
implements PrimitiveArray<int[]> {
    public IntArray(VM vm, int[] value) {
        super(vm.resolveClass("[I", new DvmClass[0]), value);
    }

    @Override
    public int length() {
        return ((int[])this.value).length;
    }

    public void setValue(int[] value) {
        this.value = value;
    }

    @Override
    public void setData(int start, int[] data2) {
        System.arraycopy(data2, 0, this.value, start, data2.length);
    }

    @Override
    public UnidbgPointer _GetArrayCritical(Emulator<?> emulator, Pointer isCopy) {
        if (isCopy != null) {
            isCopy.setInt(0L, 1);
        }
        UnidbgPointer pointer = this.allocateMemoryBlock(emulator, ((int[])this.value).length * 4);
        pointer.write(0L, (int[])this.value, 0, ((int[])this.value).length);
        return pointer;
    }

    @Override
    public void _ReleaseArrayCritical(Pointer elems, int mode) {
        switch (mode) {
            case 1: {
                this.setValue(elems.getIntArray(0L, ((int[])this.value).length));
                break;
            }
            case 0: {
                this.setValue(elems.getIntArray(0L, ((int[])this.value).length));
            }
            case 2: {
                this.freeMemoryBlock(elems);
            }
        }
    }
}

