/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventFD
extends BaseAndroidFileIO
implements NewFileIO {
    private static final Log log = LogFactory.getLog(EventFD.class);
    private final boolean semaphore;
    private final boolean nonblock;
    private long counter;

    public EventFD(int initval, boolean semaphore, boolean nonblock) {
        super(2);
        this.counter = initval;
        this.semaphore = semaphore;
        this.nonblock = nonblock;
    }

    @Override
    public int read(Backend backend, Pointer buffer, int count) {
        if (count != 8) {
            return super.read(backend, buffer, count);
        }
        if (this.counter == 0L) {
            if (this.nonblock) {
                return -1;
            }
            throw new UnsupportedOperationException();
        }
        if (this.semaphore) {
            buffer.setLong(0L, 1L);
            --this.counter;
        } else {
            buffer.setLong(0L, this.counter);
            this.counter = 0L;
        }
        return 8;
    }

    @Override
    public int write(byte[] data2) {
        if (data2.length != 8) {
            return super.write(data2);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long cnt = buffer.getLong();
        this.counter += cnt;
        if (log.isDebugEnabled()) {
            log.debug("write cnt=" + cnt + ", counter=" + this.counter);
        }
        return 8;
    }

    @Override
    public void close() {
    }
}

