/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.LinuxFileSystem;
import com.github.unidbg.linux.android.LogCatHandler;
import com.github.unidbg.linux.android.LogCatLevel;
import com.github.unidbg.linux.file.LocalUdpSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalAndroidUdpSocket
extends LocalUdpSocket
implements AndroidFileIO {
    private static final Log log = LogFactory.getLog(LocalAndroidUdpSocket.class);

    public LocalAndroidUdpSocket(Emulator<?> emulator) {
        super(emulator);
    }

    @Override
    protected int connect(String path) {
        if ("/dev/socket/logdw".equals(path)) {
            this.handler = new LocalUdpSocket.UdpHandler(){
                private static final int LOG_ID_MAIN = 0;
                private static final int LOG_ID_RADIO = 1;
                private static final int LOG_ID_EVENTS = 2;
                private static final int LOG_ID_SYSTEM = 3;
                private static final int LOG_ID_CRASH = 4;
                private static final int LOG_ID_KERNEL = 5;
                private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

                @Override
                public void handle(byte[] request) {
                    try {
                        String type;
                        this.byteArrayOutputStream.write(request);
                        if (this.byteArrayOutputStream.size() <= 11) {
                            return;
                        }
                        int tagIndex = -1;
                        int bodyIndex = -1;
                        byte[] body = this.byteArrayOutputStream.toByteArray();
                        ByteBuffer buffer = ByteBuffer.wrap(body);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        int id = buffer.get() & 0xFF;
                        int tid = buffer.getShort() & 0xFFFF;
                        int tv_sec = buffer.getInt();
                        int tv_nsec = buffer.getInt();
                        if (log.isDebugEnabled()) {
                            log.debug("handle id=" + id + ", tid=" + tid + ", tv_sec=" + tv_sec + ", tv_nsec=" + tv_nsec);
                        }
                        switch (id) {
                            case 0: {
                                type = "main";
                                break;
                            }
                            case 1: {
                                type = "radio";
                                break;
                            }
                            case 2: {
                                type = "events";
                                break;
                            }
                            case 3: {
                                type = "system";
                                break;
                            }
                            case 4: {
                                type = "crash";
                                break;
                            }
                            case 5: {
                                type = "kernel";
                                break;
                            }
                            default: {
                                type = Integer.toString(id);
                            }
                        }
                        for (int i = 12; i < body.length; ++i) {
                            if (body[i] != 0) continue;
                            if (tagIndex == -1) {
                                tagIndex = i;
                                continue;
                            }
                            bodyIndex = i;
                            break;
                        }
                        if (tagIndex != -1 && bodyIndex != -1) {
                            this.byteArrayOutputStream.reset();
                            int value = body[11] & 0xFF;
                            String tag = new String(body, 12, tagIndex - 12);
                            String text = new String(body, tagIndex + 1, bodyIndex - tagIndex - 1);
                            LogCatLevel level = LogCatLevel.valueOf(value);
                            LinuxFileSystem fileSystem = (LinuxFileSystem)LocalAndroidUdpSocket.this.emulator.getFileSystem();
                            LogCatHandler handler = fileSystem.getLogCatHandler();
                            if (handler != null) {
                                handler.handleLog(type, level, tag, text);
                            } else {
                                System.err.printf("[%s]%s/%s: %s%n", new Object[]{type, level, tag, text});
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            return 0;
        }
        this.emulator.getMemory().setErrno(1);
        return -1;
    }
}

