/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.utils.Inspector;
import java.io.IOException;
import java.io.PipedOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipedWriteFileIO
extends BaseAndroidFileIO
implements AndroidFileIO {
    private static final Log log = LogFactory.getLog(PipedWriteFileIO.class);
    private final int writefd;
    private final PipedOutputStream outputStream;

    public PipedWriteFileIO(PipedOutputStream outputStream, int writefd) {
        super(1);
        this.outputStream = outputStream;
        this.writefd = writefd;
    }

    @Override
    public int write(byte[] data2) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(Inspector.inspectString(data2, "write fd=" + this.writefd));
            }
            this.outputStream.write(data2);
            return data2.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "PipedWrite: " + this.writefd;
    }
}

