/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.StdoutCallback;
import com.github.unidbg.linux.file.SimpleFileIO;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Stdout
extends SimpleFileIO {
    private static final Log log = LogFactory.getLog(Stdout.class);
    private final boolean err;
    private final PrintStream out;
    private final StdoutCallback callback;
    private RandomAccessFile output;

    public Stdout(int oflags, File file, String path, boolean err, StdoutCallback callback2) {
        super(oflags, file, path);
        this.callback = callback2;
        this.err = err;
        PrintStream printStream = this.out = err ? System.err : System.out;
        if (log.isDebugEnabled()) {
            this.setDebugStream(err ? System.err : System.out);
        }
        this.stdio = true;
    }

    @Override
    public void close() {
        super.close();
        IOUtils.close(this.output);
    }

    @Override
    public int write(byte[] data2) {
        try {
            if (this.output == null) {
                this.output = new RandomAccessFile(this.file, "rw");
                this.output.getChannel().truncate(0L);
            }
            if (this.debugStream != null) {
                this.debugStream.write(data2);
            }
            if (log.isWarnEnabled()) {
                this.out.write(data2);
                this.out.flush();
            }
            if (this.callback != null) {
                this.callback.notifyOut(data2, this.err);
            }
            this.output.write(data2);
            return data2.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int lseek(int offset, int whence) {
        try {
            switch (whence) {
                case 0: {
                    this.output.seek(offset);
                    return (int)this.output.getFilePointer();
                }
                case 1: {
                    this.output.seek(this.output.getFilePointer() + (long)offset);
                    return (int)this.output.getFilePointer();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.lseek(offset, whence);
    }

    @Override
    public int ftruncate(int length) {
        try {
            this.output.getChannel().truncate(length);
            return 0;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public FileIO dup2() {
        Stdout dup = new Stdout(0, this.file, this.path, this.err, this.callback);
        dup.debugStream = this.debugStream;
        dup.op = this.op;
        dup.oflags = this.oflags;
        return dup;
    }
}

