/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.signal;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.linux.signal.SigAction;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.signal.AbstractSignalTask;
import com.github.unidbg.signal.SigSet;
import com.github.unidbg.signal.SignalOps;
import com.github.unidbg.signal.UnixSigSet;
import com.sun.jna.Pointer;

public class SignalTask
extends AbstractSignalTask {
    private final SigAction action;
    private Pointer sig_info;
    private UnidbgPointer stack;
    private MemoryBlock ucontext;
    private MemoryBlock infoBlock;

    public SignalTask(int signum, SigAction action) {
        this(signum, action, null);
    }

    public SignalTask(int signum, SigAction action, Pointer sig_info) {
        super(signum);
        this.action = action;
        this.sig_info = sig_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number callHandler(SignalOps signalOps, AbstractEmulator<?> emulator) {
        SigSet sigSet = signalOps.getSigMaskSet();
        try {
            Number number;
            long sa_mask = this.action.getMask();
            if (sigSet == null) {
                UnixSigSet newSigSet = new UnixSigSet(sa_mask);
                signalOps.setSigMaskSet(newSigSet);
            } else {
                sigSet.blockSigSet(sa_mask);
            }
            if (this.isContextSaved()) {
                number = this.continueRun(emulator, emulator.getReturnAddress());
                return number;
            }
            number = this.runHandler(emulator);
            return number;
        }
        finally {
            signalOps.setSigMaskSet(sigSet);
        }
    }

    private Number runHandler(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.stack == null) {
            this.stack = this.allocateStack(emulator);
        }
        if (this.action.needSigInfo() && this.infoBlock == null && this.sig_info == null) {
            this.infoBlock = emulator.getMemory().malloc(128, true);
            this.infoBlock.getPointer().setInt(0L, this.signum);
            this.sig_info = this.infoBlock.getPointer();
        }
        if (this.ucontext == null) {
            this.ucontext = emulator.getMemory().malloc(4096, true);
        }
        if (emulator.is32Bit()) {
            backend.reg_write(12, this.stack.peer);
            backend.reg_write(66, this.signum);
            backend.reg_write(67, UnidbgPointer.nativeValue(this.sig_info));
            backend.reg_write(68, UnidbgPointer.nativeValue(this.ucontext.getPointer()));
            backend.reg_write(10, emulator.getReturnAddress());
        } else {
            backend.reg_write(4, this.stack.peer);
            backend.reg_write(199, this.signum);
            backend.reg_write(200, UnidbgPointer.nativeValue(this.sig_info));
            backend.reg_write(201, UnidbgPointer.nativeValue(this.ucontext.getPointer()));
            backend.reg_write(2, emulator.getReturnAddress());
        }
        return emulator.emulate(this.action.getSaHandler(), emulator.getReturnAddress());
    }

    @Override
    public String toThreadString() {
        return "SignalTask sa_handler=0x" + Long.toHexString(this.action.getSaHandler()) + ", stack=" + this.stack + ", signum=" + this.signum;
    }

    @Override
    public void destroy(Emulator<?> emulator) {
        super.destroy(emulator);
        if (this.ucontext != null) {
            this.ucontext.free();
            this.ucontext = null;
        }
        if (this.infoBlock != null) {
            this.infoBlock.free();
            this.infoBlock = null;
        }
    }
}

