/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.EditableArm32RegisterContext;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unix.ThreadJoinVisitor;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ThreadClonePatcher32
extends ArmSvc {
    private static final Log log = LogFactory.getLog(ThreadClonePatcher32.class);
    private final ThreadJoinVisitor visitor;
    private final AtomicInteger value_ptr;
    private int threadId;

    public ThreadClonePatcher32(ThreadJoinVisitor visitor, AtomicInteger value_ptr) {
        this.visitor = visitor;
        this.value_ptr = value_ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long handle(Emulator<?> emulator) {
        EditableArm32RegisterContext context = (EditableArm32RegisterContext)emulator.getContext();
        UnidbgPointer start_routine = context.getPointerArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        int flags = context.getIntArg(2);
        UnidbgPointer arg = context.getPointerArg(3);
        log.info("pthread_clone start_routine=" + start_routine + ", child_stack=" + child_stack + ", flags=0x" + Integer.toHexString(flags) + ", arg=" + arg);
        Backend backend = emulator.getBackend();
        boolean join = this.visitor == null || this.visitor.canJoin(start_routine, ++this.threadId);
        UnidbgPointer pointer = UnidbgPointer.register(emulator, 12);
        try {
            pointer = pointer.share(-4L, 0L);
            pointer.setInt(0L, this.threadId);
            pointer = pointer.share(-4L, 0L);
            pointer.setInt(0L, join ? 1 : 0);
        }
        finally {
            backend.reg_write(12, pointer.peer);
        }
        return context.getR0Int();
    }

    @Override
    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
            KeystoneEncoded encoded = keystone.assemble(Arrays.asList("push {r4-r7, lr}", "svc #0x" + Integer.toHexString(svcNumber), "pop {r7}", "cmp r7, #0", "popeq {r0, r4-r7, pc}", "mov ip, r0", "mov r0, r3", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34918), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "blx ip", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34952), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "pop {r0, r4-r7, pc}"));
            byte[] code = encoded.getMachineCode();
            UnidbgPointer pointer = svcMemory.allocate(code.length, this.getClass().getSimpleName());
            pointer.write(code);
            UnidbgPointer unidbgPointer = pointer;
            return unidbgPointer;
        }
    }

    @Override
    public void handlePreCallback(Emulator<?> emulator) {
        if (this.visitor.isSaveContext()) {
            emulator.pushContext(4);
        }
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
        super.handlePostCallback(emulator);
        this.value_ptr.set(emulator.getContext().getIntArg(0));
    }
}

