/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.memory;

import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class MemoryBlockImpl
implements MemoryBlock {
    private final Memory memory;
    private final UnidbgPointer pointer;

    public static MemoryBlock alloc(Memory memory, int length) {
        UnidbgPointer pointer = memory.mmap(length, 3);
        return new MemoryBlockImpl(memory, pointer);
    }

    public static MemoryBlock allocExecutable(Memory memory, int length) {
        UnidbgPointer pointer = memory.mmap(length, 5);
        return new MemoryBlockImpl(memory, pointer);
    }

    private MemoryBlockImpl(Memory memory, UnidbgPointer pointer) {
        this.memory = memory;
        this.pointer = pointer;
    }

    @Override
    public UnidbgPointer getPointer() {
        return this.pointer;
    }

    @Override
    public boolean isSame(Pointer pointer) {
        return this.pointer.equals(pointer);
    }

    @Override
    public void free() {
        this.memory.munmap(this.pointer.peer, (int)this.pointer.getSize());
    }
}

