/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class Inspector {
    public static final int WPE = 16;
    public static final int MNM = 20;

    public static void inspectMapData(String label, byte[] data2, int mode) {
        int i;
        if (data2 == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n>-----------------------------------------------------------------------------<\n");
        buffer.append(new SimpleDateFormat("[HH:mm:ss SSS]").format(new Date()));
        buffer.append(label);
        buffer.append("\nsize: ").append(data2.length).append('\n');
        for (i = 0; i < data2.length; ++i) {
            int di = data2[i] & 0xFF;
            if (di != 0) {
                String hex = Integer.toString(di, 16).toUpperCase();
                if (hex.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
            } else {
                buffer.append("  ");
            }
            buffer.append(' ');
            if ((i + 1) % mode != 0) continue;
            buffer.append('\n');
        }
        int redex = mode - i % mode;
        for (int k = 0; k < redex && redex < mode; k = (int)((byte)(k + 1))) {
            buffer.append("  ");
            buffer.append(' ');
        }
        int count = i % mode;
        int start = i - count;
        if (start < i) {
            buffer.append("   ");
        }
        for (int k = start; k < i; ++k) {
            buffer.append(Inspector.toChar(data2[k]));
        }
        if (redex < mode) {
            buffer.append('\n');
        }
        buffer.append("^-----------------------------------------------------------------------------^");
        System.out.println(buffer);
    }

    public static void available(InputStream dis) throws IOException {
        if (dis == null) {
            System.out.println("available=null");
            return;
        }
        int size = dis.available();
        byte[] data2 = new byte[size];
        if (dis.read(data2) != size) {
            throw new IOException("Read available failed.");
        }
        Inspector.inspect(data2, "Available");
    }

    public boolean accept(byte[] data2, String label) {
        return true;
    }

    public boolean acceptObject(Object obj) {
        return true;
    }

    public static void inspectMapData(String label, short[][] data2) {
        Inspector.inspectMapData(label, data2, -1);
    }

    public static void inspectMapData(String label, short[][] data2, int filter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n>-----------------------------------------------------------------------------<\n");
        buffer.append(new SimpleDateFormat("[HH:mm:ss SSS]").format(new Date()));
        buffer.append(data2.length);
        if (data2.length > 0) {
            buffer.append('x').append(data2[0].length);
        }
        buffer.append(label).append('\n');
        short[][] sArray = data2;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short[] dt;
            for (short ds : dt = sArray[i]) {
                int di = ds & 0xFFFF;
                if (di == filter) {
                    buffer.append("     ");
                    continue;
                }
                String hex = Integer.toString(di, 16).toUpperCase();
                for (int n2 = 0; n2 < 4 - hex.length(); ++n2) {
                    buffer.append('0');
                }
                buffer.append(hex);
                buffer.append(' ');
            }
            buffer.append('\n');
        }
        buffer.append("^-----------------------------------------------------------------------------^");
        System.out.println(buffer);
    }

    public static void inspect(String label, byte[][] data2) {
        Inspector.inspect(label, data2, -1);
    }

    public static void inspect(String label, short[] data2) {
        System.out.println(Inspector.inspectString(null, label, data2, 16));
    }

    public static String inspectString(Date date, String label, short[] data2, int mode) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n>-----------------------------------------------------------------------------<\n");
        if (date == null) {
            date = new Date();
        }
        buffer.append(new SimpleDateFormat("[HH:mm:ss SSS]").format(date));
        buffer.append(label);
        buffer.append("\nsize: ");
        if (data2 != null) {
            buffer.append(data2.length);
        } else {
            buffer.append("null");
        }
        buffer.append('\n');
        if (data2 != null) {
            int i;
            for (i = 0; i < data2.length; ++i) {
                int di = data2[i] & 0xFFFF;
                String hex = Integer.toString(di, 16).toUpperCase();
                for (int n = 0; n < 4 - hex.length(); ++n) {
                    buffer.append('0');
                }
                buffer.append(hex);
                buffer.append(' ');
                if ((i + 1) % mode != 0) continue;
                buffer.append('\n');
            }
            if (i % mode != 0) {
                buffer.append('\n');
            }
        }
        buffer.append("^-----------------------------------------------------------------------------^");
        return buffer.toString();
    }

    public static void inspect(String label, byte[][] data2, int filter) {
        System.out.println(Inspector.inspectString(label, data2, filter));
    }

    public static void inspect(Date date, String label, byte[] data2, int mode) {
        System.out.println(Inspector.inspectInternal(date, label, data2, mode));
    }

    private static String inspectInternal(Date date, String label, byte[] data2, int mode) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n>-----------------------------------------------------------------------------<\n");
        if (date == null) {
            date = new Date();
        }
        buffer.append(new SimpleDateFormat("[HH:mm:ss SSS]").format(date));
        buffer.append(label);
        if (data2 != null) {
            buffer.append(", md5=").append(Hex.encodeHex(DigestUtils.md5(data2)));
            if (data2.length < 1024) {
                buffer.append(", hex=").append(Hex.encodeHex(data2));
            }
        }
        buffer.append("\nsize: ");
        if (data2 != null) {
            buffer.append(data2.length);
        } else {
            buffer.append("null");
        }
        buffer.append('\n');
        if (data2 != null) {
            int i;
            for (i = 0; i < data2.length; ++i) {
                int di;
                String hex;
                if (i % mode == 0) {
                    String hex2 = Integer.toHexString(i % 65536).toUpperCase();
                    int fill = 4 - hex2.length();
                    for (int k = 0; k < fill; ++k) {
                        buffer.append('0');
                    }
                    buffer.append(hex2).append(": ");
                }
                if ((hex = Integer.toString(di = data2[i] & 0xFF, 16).toUpperCase()).length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
                buffer.append(' ');
                if ((i + 1) % mode != 0) continue;
                buffer.append("   ");
                for (int k = i - 15; k < i + 1; ++k) {
                    buffer.append(Inspector.toChar(data2[k]));
                }
                buffer.append('\n');
            }
            int redex = mode - i % mode;
            for (int k = 0; k < redex && redex < mode; k = (int)((byte)(k + 1))) {
                buffer.append("  ");
                buffer.append(' ');
            }
            int count = i % mode;
            int start = i - count;
            if (start < i) {
                buffer.append("   ");
            }
            for (int k = start; k < i; ++k) {
                buffer.append(Inspector.toChar(data2[k]));
            }
            if (redex < mode) {
                buffer.append('\n');
            }
        }
        buffer.append("^-----------------------------------------------------------------------------^");
        return buffer.toString();
    }

    public static void inspect(String label, byte[] data2, int mode) {
        Inspector.inspect(null, label, data2, mode);
    }

    public static void inspect(byte[] data2, boolean send) {
        Inspector.inspect(send ? "\u53d1\u9001\u6570\u636e" : "\u63a5\u6536\u6570\u636e", data2, 16);
    }

    public static void inspect(int type, byte[] data2, boolean send) {
        String ts = Integer.toHexString(type).toUpperCase();
        Inspector.inspect(send ? "\u53d1\u9001\u6570\u636e\uff1a0x" + ts : "\u63a5\u6536\u6570\u636e\uff1a0x" + ts, data2, 16);
    }

    public static void inspect(byte[] data2, String label) {
        Inspector.inspect(label, data2, 16);
    }

    private static char toChar(byte in) {
        if (in == 32) {
            return ' ';
        }
        if (in > 126 || in < 33) {
            return '.';
        }
        return (char)in;
    }

    public static void objectType(Object in) {
        if (in == null) {
            System.out.println("Object type is null");
            return;
        }
        System.out.println("Object type is " + in.getClass() + '[' + in + ']');
    }

    protected Integer detectedType(byte[] data2, boolean send) {
        return null;
    }

    public static void inspect(String label, int value) {
        System.out.println(label + "0x" + Integer.toHexString(value).toUpperCase());
    }

    public static void throwError() {
        throw new Error("auxiliary error");
    }

    public static void throwError(int errorValue, int testValue) {
        if (testValue != errorValue) {
            return;
        }
        throw new Error("auxiliary error");
    }

    public static void where() {
        Thread.dumpStack();
    }

    public static void where(int testValue, int printValue) {
        if (testValue != printValue) {
            return;
        }
        Inspector.where();
    }

    protected static void close(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void close(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String inspectString(String label, byte[][] data2) {
        return Inspector.inspectString(label, data2, -1);
    }

    public static String inspectString(String label, short[] data2) {
        return Inspector.inspectString(new Date(), label, data2);
    }

    public static String inspectString(Date date, String label, short[] data2) {
        return Inspector.inspectString(date, label, data2, 16);
    }

    public static String inspectString(String label, byte[][] data2, int filter) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n>-----------------------------------------------------------------------------<\n");
        buffer.append(new SimpleDateFormat("[HH:mm:ss SSS]").format(new Date()));
        if (data2.length > 0) {
            buffer.append(data2[0].length).append('x');
        }
        buffer.append(data2.length);
        buffer.append(label).append('\n');
        byte[][] byArray = data2;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] dt;
            for (byte db : dt = byArray[i]) {
                int di = db & 0xFF;
                if (di == filter) {
                    buffer.append("   ");
                    continue;
                }
                String hex = Integer.toString(di, 16).toUpperCase();
                if (hex.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
                buffer.append(' ');
            }
            buffer.append('\n');
        }
        buffer.append("^-----------------------------------------------------------------------------^");
        return buffer.toString();
    }

    public static String inspectString(String label, byte[] data2, int mode) {
        return Inspector.inspectString(null, label, data2, mode);
    }

    public static String inspectString(Date date, String label, byte[] data2, int mode) {
        return Inspector.inspectInternal(date, label, data2, mode);
    }

    public static String inspectString(byte[] data2, boolean send) {
        return Inspector.inspectString(send ? "Sent" : "Received", data2, 16);
    }

    public static String inspectString(int type, byte[] data2, boolean send) {
        String ts = Integer.toHexString(type).toUpperCase();
        return Inspector.inspectString(send ? "\u53d1\u9001\u6570\u636e: 0x" + ts : "\u63a5\u6536\u6570\u636e: 0x" + ts, data2, 16);
    }

    public static String inspectString(byte[] data2, String label) {
        return Inspector.inspectString(label, data2, 16);
    }
}

