/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.virtualmodule;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class VirtualModule<T> {
    private static final Log log = LogFactory.getLog(VirtualModule.class);
    private final String name;
    private final Map<String, UnidbgPointer> symbols = new HashMap<String, UnidbgPointer>();

    protected VirtualModule(Emulator<?> emulator, String name) {
        this(emulator, null, name);
    }

    protected VirtualModule(Emulator<?> emulator, T extra, String name) {
        this.name = name;
        this.onInitialize(emulator, extra, this.symbols);
    }

    protected abstract void onInitialize(Emulator<?> var1, T var2, Map<String, UnidbgPointer> var3);

    public Module register(Memory memory) {
        if (this.name == null || this.name.trim().length() < 1) {
            throw new IllegalArgumentException("name is empty");
        }
        if (this.symbols.isEmpty()) {
            throw new IllegalArgumentException("symbols is empty");
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Register virtual module[%s]: (%s)", this.name, this.symbols));
        }
        return memory.loadVirtualModule(this.name, this.symbols);
    }
}

