/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.worker;

import com.github.unidbg.worker.Worker;
import com.github.unidbg.worker.WorkerFactory;
import com.github.unidbg.worker.WorkerPool;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scijava.nativelib.NativeLibraryUtil;

class DefaultWorkerPool
implements WorkerPool,
Runnable {
    private static final Log log = LogFactory.getLog(DefaultWorkerPool.class);
    private final BlockingQueue<Worker> releaseQueue = new LinkedBlockingQueue<Worker>();
    private final BlockingQueue<Worker> workers;
    private final WorkerFactory factory;
    private final int workerCount;
    private boolean stopped;
    private int created;

    DefaultWorkerPool(WorkerFactory factory, int workerCount) {
        if (NativeLibraryUtil.getArchitecture() == NativeLibraryUtil.Architecture.OSX_ARM64 && workerCount > 1) {
            workerCount = 1;
        }
        this.factory = factory;
        this.workerCount = workerCount;
        this.workers = new LinkedBlockingQueue<Worker>(workerCount == 1 ? 1 : workerCount - 1);
        Thread thread = new Thread((Runnable)this, "worker pool for " + factory);
        thread.start();
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Worker release;
                Worker worker = release = this.created >= this.workerCount ? this.releaseQueue.poll(10L, TimeUnit.MILLISECONDS) : (Worker)this.releaseQueue.poll();
                if (release != null) {
                    this.workers.put(release);
                    continue;
                }
                if (this.created >= this.workerCount) continue;
                this.workers.put(this.factory.createWorker(this));
                ++this.created;
            }
            catch (InterruptedException e) {
                log.warn("worker pool loop failed", e);
                break;
            }
        }
        DefaultWorkerPool.closeWorkers(this.releaseQueue);
        DefaultWorkerPool.closeWorkers(this.workers);
    }

    private static void closeWorkers(BlockingQueue<Worker> queue) {
        Worker worker;
        while ((worker = (Worker)queue.poll()) != null) {
            worker.destroy();
        }
    }

    @Override
    public void close() {
        this.stopped = true;
        DefaultWorkerPool.closeWorkers(this.workers);
    }

    @Override
    public <T extends Worker> T borrow(long timeout, TimeUnit unit) {
        if (this.stopped) {
            return null;
        }
        try {
            return (T)this.workers.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            log.warn("borrow failed", e);
            return null;
        }
    }

    @Override
    public void release(Worker worker) {
        if (this.stopped) {
            worker.destroy();
        } else if (!this.releaseQueue.offer(worker)) {
            throw new IllegalStateException("Release worker failed.");
        }
    }
}

