/*
 * Decompiled with CFR 0.152.
 */
package keystone;

import java.util.HashMap;
import java.util.Map;
import keystone.jna.JnaEnum;

public enum KeystoneMode implements JnaEnum
{
    LittleEndian(0),
    BigEndian(0x40000000),
    Arm(1),
    ArmThumb(16),
    ArmV8(64),
    MipsMicro(16),
    Mips3(32),
    Mips32r6(64),
    Mips32(4),
    Mips64(8),
    Mode16(2),
    Mode32(4),
    Mode64(8),
    Ppc32(4),
    Ppc64(8),
    PpcQpx(16),
    Sparc32(4),
    Sparc64(8),
    SparcV9(16);

    private static Map<Integer, KeystoneMode> intToEnumMapping;
    private final int value;

    private KeystoneMode(int value) {
        this.value = value;
    }

    public static KeystoneMode fromValue(Integer value) {
        return intToEnumMapping.get(value);
    }

    @Override
    public int value() {
        return this.value;
    }

    static {
        intToEnumMapping = new HashMap<Integer, KeystoneMode>();
        for (KeystoneMode mode : KeystoneMode.values()) {
            intToEnumMapping.put(mode.value(), mode);
        }
    }
}

