/*
 * Decompiled with CFR 0.152.
 */
package moe.fuqiuluo.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u001a\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nH\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nH\u0007J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\"\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0007\u00a8\u0006#"}, d2={"Lmoe/fuqiuluo/utils/BytesUtil;", "", "()V", "bufToInt16", "", "bArr", "", "i", "bufToInt32", "bufToInt64", "", "bufToInt8", "byte2float", "", "b", "index", "byteMerger", "first", "second", "doubleToByte", "num", "", "float2byte", "f", "getDouble", "int16ToBuf", "int32ToBuf", "int64ToBuf", "j", "int64ToBuf32", "randomKey", "size", "subByte", "off", "length", "qsign"})
public final class BytesUtil {
    @NotNull
    public static final BytesUtil INSTANCE = new BytesUtil();

    private BytesUtil() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] byteMerger(@NotNull byte[] first, @NotNull byte[] second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        byte[] byArray = Arrays.copyOf(first, first.length + second.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] result = byArray;
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final byte[] int16ToBuf(int i) {
        byte[] out = new byte[2];
        out[1] = (byte)i;
        out[0] = (byte)(i >> 8);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] int32ToBuf(int i) {
        byte[] out = new byte[4];
        out[3] = (byte)i;
        out[2] = (byte)(i >> 8);
        out[1] = (byte)(i >> 16);
        out[0] = (byte)(i >> 24);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] int64ToBuf(long j) {
        byte[] out = new byte[8];
        out[7] = (byte)j;
        out[6] = (byte)(j >> 8);
        out[5] = (byte)(j >> 16);
        out[4] = (byte)(j >> 24);
        out[3] = (byte)(j >> 32);
        out[2] = (byte)(j >> 40);
        out[1] = (byte)(j >> 48);
        out[0] = (byte)(j >> 56);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] int64ToBuf32(long j) {
        byte[] out = new byte[4];
        out[3] = (byte)j;
        out[2] = (byte)(j >> 8);
        out[1] = (byte)(j >> 16);
        out[0] = (byte)(j >> 24);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] float2byte(float f) {
        int fbit = Float.floatToIntBits(f);
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(fbit >> 24 - i * 8);
        }
        int len = b.length;
        byte[] dest = new byte[len];
        System.arraycopy(b, 0, dest, 0, len);
        byte temp = 0;
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            temp = dest[i];
            dest[i] = dest[len - i - 1];
            dest[len - i - 1] = temp;
        }
        return dest;
    }

    @JvmStatic
    @NotNull
    public static final byte[] doubleToByte(double num) {
        byte[] b = new byte[8];
        long l = Double.doubleToLongBits(num);
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)l;
            l >>= 8;
        }
        return b;
    }

    @JvmStatic
    public static final double getDouble(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long m = b[0];
        m &= 0xFFL;
        m |= (long)b[1] << 8;
        m &= 0xFFFFL;
        m |= (long)b[2] << 16;
        m &= 0xFFFFFFL;
        m |= (long)b[3] << 24;
        m &= 0xFFFFFFFFL;
        m |= (long)b[4] << 32;
        m &= 0xFFFFFFFFFFL;
        m |= (long)b[5] << 40;
        m &= 0xFFFFFFFFFFFFL;
        m |= (long)b[6] << 48;
        m &= 0xFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(m |= (long)b[7] << 56);
    }

    @JvmStatic
    public static final float byte2float(@NotNull byte[] b, int index) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int l = b[index + 0];
        l &= 0xFF;
        l |= (int)((long)b[index + 1] << 8);
        l &= 0xFFFF;
        l |= (int)((long)b[index + 2] << 16);
        l &= 0xFFFFFF;
        return Float.intBitsToFloat(l |= (int)((long)b[index + 3] << 24));
    }

    @JvmStatic
    public static final int bufToInt8(@NotNull byte[] bArr, int i) {
        Intrinsics.checkNotNullParameter((Object)bArr, (String)"bArr");
        return bArr[i] & 0xFF;
    }

    @JvmStatic
    public static final int bufToInt16(@NotNull byte[] bArr, int i) {
        Intrinsics.checkNotNullParameter((Object)bArr, (String)"bArr");
        return (bArr[i] << 8 & 0xFF00) + (bArr[i + 1] & 0xFF);
    }

    @JvmStatic
    public static final int bufToInt32(@NotNull byte[] bArr, int i) {
        Intrinsics.checkNotNullParameter((Object)bArr, (String)"bArr");
        return (bArr[i] << 24 & 0xFF000000) + (bArr[i + 1] << 16 & 0xFF0000) + (bArr[i + 2] << 8 & 0xFF00) + (bArr[i + 3] & 0xFF);
    }

    public static /* synthetic */ int bufToInt32$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return BytesUtil.bufToInt32(byArray, n);
    }

    @JvmStatic
    public static final long bufToInt64(@NotNull byte[] bArr, int i) {
        Intrinsics.checkNotNullParameter((Object)bArr, (String)"bArr");
        return ((long)bArr[i] << 56 & 0xFF00000000000000L) + ((long)bArr[i + 1] << 48 & 0xFF000000000000L) + ((long)bArr[i + 2] << 40 & 0xFF0000000000L) + ((long)bArr[i + 3] << 32 & 0xFF00000000L) + ((long)bArr[i + 4] << 24 & 0xFF000000L) + ((long)bArr[i + 5] << 16 & 0xFF0000L) + ((long)bArr[i + 6] << 8 & 0xFF00L) + ((long)bArr[i + 7] & 0xFFL);
    }

    @JvmStatic
    @Nullable
    public static final byte[] subByte(@NotNull byte[] b, int off, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(b.length == 0)) {
            byte[] b1 = new byte[length];
            System.arraycopy(b, off, b1, 0, length);
            return b1;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final byte[] randomKey(int size) {
        return Random.Default.nextBytes(size);
    }
}

