/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.AbstractApkFile;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Inputs;

public class ApkFile
extends AbstractApkFile
implements Closeable {
    private final ZipFile zf;
    private File apkFile;
    @Nullable
    private FileChannel fileChannel;

    public ApkFile(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
    }

    public ApkFile(String filePath) throws IOException {
        this(new File(filePath));
    }

    @Override
    protected List<AbstractApkFile.CertificateFile> getAllCertificateData() throws IOException {
        Enumeration<? extends ZipEntry> enu = this.zf.entries();
        ArrayList<AbstractApkFile.CertificateFile> list = new ArrayList<AbstractApkFile.CertificateFile>();
        while (enu.hasMoreElements()) {
            String name;
            ZipEntry ne = enu.nextElement();
            if (ne.isDirectory() || !(name = ne.getName().toUpperCase()).endsWith(".RSA") && !name.endsWith(".DSA")) continue;
            list.add(new AbstractApkFile.CertificateFile(name, Inputs.readAllAndClose(this.zf.getInputStream(ne))));
        }
        return list;
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        return Inputs.readAllAndClose(inputStream);
    }

    @Override
    protected ByteBuffer fileData() throws IOException {
        this.fileChannel = new FileInputStream(this.apkFile).getChannel();
        return this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public ApkSignStatus verifyApk() throws IOException {
        ZipEntry entry = this.zf.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        try (JarFile jarFile = new JarFile(this.apkFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            byte[] buffer = new byte[8192];
            block23: while (entries.hasMoreElements()) {
                Object object;
                JarEntry e = entries.nextElement();
                if (e.isDirectory()) continue;
                try {
                    InputStream in = jarFile.getInputStream(e);
                    object = null;
                    try {
                        while (true) {
                            int count;
                            if ((count = in.read(buffer, 0, buffer.length)) == -1) continue block23;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in == null) continue;
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (SecurityException se) {
                    object = ApkSignStatus.incorrect;
                    if (jarFile == null) return object;
                    if (var3_3 != null) {
                        try {
                            jarFile.close();
                            return object;
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                            return object;
                        }
                    }
                    jarFile.close();
                    return object;
                }
            }
            return ApkSignStatus.signed;
        }
    }

    @Override
    public void close() throws IOException {
        try (Closeable superClosable = new Closeable(){

            @Override
            public void close() throws IOException {
                ApkFile.super.close();
            }
        };
             ZipFile zipFileClosable = this.zf;){
            FileChannel fileChannelClosable = this.fileChannel;
            Throwable throwable = null;
            if (fileChannelClosable != null) {
                if (throwable != null) {
                    try {
                        fileChannelClosable.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fileChannelClosable.close();
                }
            }
        }
    }
}

