/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dongliu.apk.parser.AbstractApkFile;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Inputs;

public class ByteArrayApkFile
extends AbstractApkFile
implements Closeable {
    private byte[] apkData;

    public ByteArrayApkFile(byte[] apkData) {
        this.apkData = apkData;
    }

    @Override
    protected List<AbstractApkFile.CertificateFile> getAllCertificateData() throws IOException {
        ArrayList<AbstractApkFile.CertificateFile> list = new ArrayList<AbstractApkFile.CertificateFile>();
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.apkData);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.toUpperCase().endsWith(".RSA") && !name.toUpperCase().endsWith(".DSA")) continue;
                list.add(new AbstractApkFile.CertificateFile(name, Inputs.readAll(zis)));
            }
        }
        return list;
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.apkData);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!path.equals(entry.getName())) continue;
                byte[] byArray = Inputs.readAll(zis);
                return byArray;
            }
        }
        return null;
    }

    @Override
    protected ByteBuffer fileData() {
        return ByteBuffer.wrap(this.apkData).asReadOnlyBuffer();
    }

    @Override
    @Deprecated
    public ApkSignStatus verifyApk() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.apkData = null;
    }
}

