/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.util.ArrayList;
import net.dongliu.apk.parser.utils.Strings;

public class AttributeValues {
    public static String getScreenOrientation(int value) {
        switch (value) {
            case 3: {
                return "behind";
            }
            case 10: {
                return "fullSensor";
            }
            case 13: {
                return "fullUser";
            }
            case 0: {
                return "landscape";
            }
            case 14: {
                return "locked";
            }
            case 5: {
                return "nosensor";
            }
            case 1: {
                return "portrait";
            }
            case 8: {
                return "reverseLandscape";
            }
            case 9: {
                return "reversePortrait";
            }
            case 4: {
                return "sensor";
            }
            case 6: {
                return "sensorLandscape";
            }
            case 7: {
                return "sensorPortrait";
            }
            case -1: {
                return "unspecified";
            }
            case 2: {
                return "user";
            }
            case 11: {
                return "userLandscape";
            }
            case 12: {
                return "userPortrait";
            }
        }
        return "ScreenOrientation:" + Integer.toHexString(value);
    }

    public static String getLaunchMode(int value) {
        switch (value) {
            case 0: {
                return "standard";
            }
            case 1: {
                return "singleTop";
            }
            case 2: {
                return "singleTask";
            }
            case 3: {
                return "singleInstance";
            }
        }
        return "LaunchMode:" + Integer.toHexString(value);
    }

    public static String getConfigChanges(int value) {
        ArrayList<String> list = new ArrayList<String>();
        if ((value & 0x1000) != 0) {
            list.add("density");
        } else if ((value & 0x40000000) != 0) {
            list.add("fontScale");
        } else if ((value & 0x10) != 0) {
            list.add("keyboard");
        } else if ((value & 0x20) != 0) {
            list.add("keyboardHidden");
        } else if ((value & 0x2000) != 0) {
            list.add("direction");
        } else if ((value & 4) != 0) {
            list.add("locale");
        } else if ((value & 1) != 0) {
            list.add("mcc");
        } else if ((value & 2) != 0) {
            list.add("mnc");
        } else if ((value & 0x40) != 0) {
            list.add("navigation");
        } else if ((value & 0x80) != 0) {
            list.add("orientation");
        } else if ((value & 0x100) != 0) {
            list.add("screenLayout");
        } else if ((value & 0x400) != 0) {
            list.add("screenSize");
        } else if ((value & 0x800) != 0) {
            list.add("smallestScreenSize");
        } else if ((value & 8) != 0) {
            list.add("touchscreen");
        } else if ((value & 0x200) != 0) {
            list.add("uiMode");
        }
        return Strings.join(list, "|");
    }

    public static String getWindowSoftInputMode(int value) {
        int adjust = value & 0xF0;
        int state = value & 0xF;
        ArrayList<String> list = new ArrayList<String>(2);
        switch (adjust) {
            case 48: {
                list.add("adjustNothing");
                break;
            }
            case 32: {
                list.add("adjustPan");
                break;
            }
            case 16: {
                list.add("adjustResize");
                break;
            }
            case 0: {
                break;
            }
            default: {
                list.add("WindowInputModeAdjust:" + Integer.toHexString(adjust));
            }
        }
        switch (state) {
            case 3: {
                list.add("stateAlwaysHidden");
                break;
            }
            case 5: {
                list.add("stateAlwaysVisible");
                break;
            }
            case 2: {
                list.add("stateHidden");
                break;
            }
            case 1: {
                list.add("stateUnchanged");
                break;
            }
            case 4: {
                list.add("stateVisible");
                break;
            }
            case 0: {
                break;
            }
            default: {
                list.add("WindowInputModeState:" + Integer.toHexString(state));
            }
        }
        return Strings.join(list, "|");
    }

    public static String getProtectionLevel(int value) {
        ArrayList<String> levels = new ArrayList<String>(3);
        if ((value & 0x10) != 0) {
            value ^= 0x10;
            levels.add("system");
        }
        if ((value & 0x20) != 0) {
            value ^= 0x20;
            levels.add("development");
        }
        switch (value) {
            case 0: {
                levels.add("normal");
                break;
            }
            case 1: {
                levels.add("dangerous");
                break;
            }
            case 2: {
                levels.add("signature");
                break;
            }
            case 3: {
                levels.add("signatureOrSystem");
                break;
            }
            default: {
                levels.add("ProtectionLevel:" + Integer.toHexString(value));
            }
        }
        return Strings.join(levels, "|");
    }

    public static String getInstallLocation(int value) {
        switch (value) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "internalOnly";
            }
            case 2: {
                return "preferExternal";
            }
        }
        return "installLocation:" + Integer.toHexString(value);
    }
}

