/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolStructure;
import net.fornwall.jelf.HashTable;

class ElfHashTable
implements HashTable {
    private final int num_buckets;
    private final int[] buckets;
    private final int[] chains;

    ElfHashTable(ElfParser parser, long offset, int length) {
        int i;
        parser.seek(offset);
        this.num_buckets = parser.readInt();
        int num_chains = parser.readInt();
        this.buckets = new int[this.num_buckets];
        this.chains = new int[num_chains];
        for (i = 0; i < this.num_buckets; ++i) {
            this.buckets[i] = parser.readInt();
        }
        for (i = 0; i < num_chains; ++i) {
            this.chains[i] = parser.readInt();
        }
        int actual = this.num_buckets * 4 + num_chains * 4 + 8;
        if (length != -1 && length != actual) {
            throw new ElfException("Error reading string table (read " + actual + "bytes, expected to read " + length + "bytes).");
        }
    }

    private static long elf_hash(String name) {
        long h = 0L;
        for (char c : name.toCharArray()) {
            h = (h << 4) + (long)c;
            long g = h & 0xF0000000L;
            h ^= g;
            h ^= g >> 24;
        }
        return h;
    }

    @Override
    public ElfSymbol getSymbol(ElfSymbolStructure symbolStructure, String symbolName) throws IOException {
        if (symbolName == null) {
            return null;
        }
        long hash = ElfHashTable.elf_hash(symbolName);
        int index = this.buckets[(int)hash % this.num_buckets];
        while (index != 0) {
            ElfSymbol symbol = symbolStructure.getELFSymbol(index);
            if (symbolName.equals(symbol.getName())) {
                return symbol;
            }
            index = this.chains[index];
        }
        return null;
    }

    @Override
    public ElfSymbol findSymbolByAddress(ElfSymbolStructure symbolStructure, long soaddr) throws IOException {
        for (int i = 0; i < this.chains.length; ++i) {
            ElfSymbol symbol = symbolStructure.getELFSymbol(i);
            if (!symbol.matches(soaddr)) continue;
            return symbol;
        }
        return null;
    }

    @Override
    public int getNumBuckets() {
        return this.num_buckets;
    }
}

