/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.nio.ByteBuffer;
import net.fornwall.jelf.ElfDataIn;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;

class ElfParser
implements ElfDataIn {
    final ElfFile elfFile;
    private final ByteBuffer fsFile;

    ElfParser(ElfFile elfFile, ByteBuffer fsFile) {
        this.elfFile = elfFile;
        this.fsFile = fsFile;
    }

    void seek(long offset) {
        this.fsFile.position((int)offset);
    }

    short byteSwap(short arg) {
        return (short)(arg << 8 | arg >>> 8 & 0xFF);
    }

    int byteSwap(int arg) {
        return this.byteSwap((short)arg) << 16 | this.byteSwap((short)(arg >>> 16)) & 0xFFFF;
    }

    long byteSwap(long arg) {
        return (long)this.byteSwap((int)arg) << 32 | (long)this.byteSwap((int)(arg >>> 32));
    }

    @Override
    public short readUnsignedByte() {
        int val = this.fsFile.get() & 0xFF;
        return (short)val;
    }

    @Override
    public short readShort() throws ElfException {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        short val = (short)((ch1 << 8) + ch2);
        if (this.elfFile.encoding == 1) {
            val = this.byteSwap(val);
        }
        return val;
    }

    @Override
    public int readInt() throws ElfException {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        short ch3 = this.readUnsignedByte();
        short ch4 = this.readUnsignedByte();
        int val = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        if (this.elfFile.encoding == 1) {
            val = this.byteSwap(val);
        }
        return val;
    }

    @Override
    public long readLong() {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        short ch3 = this.readUnsignedByte();
        short ch4 = this.readUnsignedByte();
        int val1 = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        short ch5 = this.readUnsignedByte();
        short ch6 = this.readUnsignedByte();
        short ch7 = this.readUnsignedByte();
        short ch8 = this.readUnsignedByte();
        int val2 = (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
        long val = ((long)val1 << 32) + ((long)val2 & 0xFFFFFFFFL);
        if (this.elfFile.encoding == 1) {
            val = this.byteSwap(val);
        }
        return val;
    }

    long readIntOrLong() {
        return this.elfFile.objectSize == 1 ? (long)this.readInt() : this.readLong();
    }

    long unsignedByte(int arg) {
        long val = arg >= 0 ? (long)arg : this.unsignedByte((short)(arg >>> 16)) << 16 | (long)((short)arg);
        return val;
    }

    int read(byte[] data2) {
        this.fsFile.get(data2);
        return data2.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readBuffer(int length) {
        int limit = this.fsFile.limit();
        try {
            this.fsFile.limit(this.fsFile.position() + length);
            ByteBuffer byteBuffer = this.fsFile.slice();
            return byteBuffer;
        }
        finally {
            this.fsFile.limit(limit);
        }
    }
}

