/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import java.util.Objects;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.SymbolLocator;

public class ElfRelocation
implements Cloneable {
    private final int objectSize;
    private final SymbolLocator symtab;
    long offset;
    long info;
    long addend;
    private final boolean android;
    private ElfSymbol symbol;

    ElfRelocation(ElfParser parser, long offset, long entry_size, SymbolLocator symtab) {
        this.objectSize = parser.elfFile.objectSize;
        this.symtab = symtab;
        this.android = false;
        parser.seek(offset);
        if (parser.elfFile.objectSize == 1) {
            this.offset = (long)parser.readInt() & 0xFFFFFFFFL;
            this.info = parser.readInt();
            this.addend = entry_size >= 12L ? (long)parser.readInt() : 0L;
        } else {
            this.offset = parser.readLong();
            this.info = parser.readLong();
            this.addend = entry_size >= 24L ? parser.readLong() : 0L;
        }
    }

    public ElfRelocation clone() throws CloneNotSupportedException {
        return (ElfRelocation)super.clone();
    }

    ElfRelocation(int objectSize, SymbolLocator symtab) {
        this.objectSize = objectSize;
        this.symtab = symtab;
        this.android = true;
    }

    public long offset() {
        return this.offset;
    }

    public ElfSymbol symbol() throws IOException {
        if (this.symbol == null) {
            this.symbol = this.symtab.getELFSymbol(this.sym());
        }
        return this.symbol;
    }

    public int sym() {
        int mask = this.objectSize == 1 ? 8 : 32;
        return (int)(this.info >> mask);
    }

    public int type() {
        long mask = this.objectSize == 1 ? 255L : 0xFFFFFFFFL;
        return (int)(this.info & mask);
    }

    public long addend() {
        return this.addend;
    }

    public boolean isAndroid() {
        return this.android;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElfRelocation that = (ElfRelocation)o;
        return this.offset == that.offset && this.info == that.info && this.addend == that.addend;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.info, this.addend);
    }
}

