/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.HashTable;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.SymbolLocator;

public class ElfSymbolStructure
implements SymbolLocator {
    private final ElfParser parser;
    private final long offset;
    private final int entrySize;
    private final MemoizedObject<ElfStringTable> stringTable;
    private final MemoizedObject<HashTable> hashTable;

    ElfSymbolStructure(ElfParser parser, long offset, int entrySize, MemoizedObject<ElfStringTable> stringTable, MemoizedObject<HashTable> hashTable) {
        this.parser = parser;
        this.offset = offset;
        this.entrySize = entrySize;
        this.stringTable = stringTable;
        this.hashTable = hashTable;
    }

    @Override
    public ElfSymbol getELFSymbol(int index) throws IOException {
        return new ElfSymbol(this.parser, this.offset + (long)index * (long)this.entrySize, -1).setStringTable(this.stringTable.getValue());
    }

    @Override
    public ElfSymbol getELFSymbolByAddr(long addr) throws IOException {
        if (this.hashTable == null) {
            throw new UnsupportedOperationException("hashTable is null");
        }
        return this.hashTable.getValue().findSymbolByAddress(this, addr);
    }

    @Override
    public ElfSymbol getELFSymbolByName(String name) throws IOException {
        if (this.hashTable == null) {
            return null;
        }
        return this.hashTable.getValue().getSymbol(this, name);
    }
}

