/*
 * Decompiled with CFR 0.152.
 */
package capstone;

import capstone.Capstone;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.Arrays;
import java.util.List;

public class X86 {

    public static class OpInfo
    implements Capstone.OpInfo {
        public byte[] prefix;
        public byte[] opcode;
        public byte opSize;
        public byte rex;
        public byte addrSize;
        public byte dispSize;
        public byte immSize;
        public byte modrm;
        public byte sib;
        public long disp;
        public int sibIndex;
        public byte sibScale;
        public int sibBase;
        public int xopCC;
        public int sseCC;
        public int avxCC;
        public boolean avxSae;
        public int avxRm;
        public long eflags;
        public Operand[] op;
        public Encoding encoding;

        public OpInfo(UnionOpInfo e) {
            this.prefix = e.prefix;
            this.opcode = e.opcode;
            this.rex = e.rex;
            this.addrSize = e.addr_size;
            this.modrm = e.modrm;
            this.sib = e.sib;
            this.disp = e.disp;
            this.sibIndex = e.sib_index;
            this.sibScale = e.sib_scale;
            this.sibBase = e.sib_base;
            this.xopCC = e.xop_cc;
            this.sseCC = e.sse_cc;
            this.avxCC = e.avx_cc;
            this.avxSae = e.avx_sae > 0;
            this.avxRm = e.avx_rm;
            this.eflags = e.eflags;
            this.op = new Operand[e.op_count];
            for (int i = 0; i < e.op_count; ++i) {
                this.op[i] = e.op[i];
            }
            this.encoding = e.encoding;
        }
    }

    public static class UnionOpInfo
    extends Capstone.UnionOpInfo {
        public byte[] prefix;
        public byte[] opcode;
        public byte rex;
        public byte addr_size;
        public byte modrm;
        public byte sib;
        public long disp;
        public int sib_index;
        public byte sib_scale;
        public int sib_base;
        public int xop_cc;
        public int sse_cc;
        public int avx_cc;
        public byte avx_sae;
        public int avx_rm;
        public long eflags;
        public byte op_count;
        public Operand[] op = new Operand[8];
        public Encoding encoding;

        public UnionOpInfo() {
            this.opcode = new byte[4];
            this.prefix = new byte[4];
        }

        public List getFieldOrder() {
            return Arrays.asList("prefix", "opcode", "rex", "addr_size", "modrm", "sib", "disp", "sib_index", "sib_scale", "sib_base", "xop_cc", "sse_cc", "avx_cc", "avx_sae", "avx_rm", "eflags", "op_count", "op", "encoding");
        }
    }

    public static class Operand
    extends Structure {
        public int type;
        public OpValue value;
        public byte size;
        public byte access;
        public int avx_bcast;
        public boolean avx_zero_opmask;

        @Override
        public void read() {
            super.read();
            if (this.type == 3) {
                this.value.setType(MemType.class);
            }
            if (this.type == 2) {
                this.value.setType(Long.TYPE);
            }
            if (this.type == 1) {
                this.value.setType(Integer.TYPE);
            }
            if (this.type == 0) {
                return;
            }
            this.readField("value");
        }

        public List getFieldOrder() {
            return Arrays.asList("type", "value", "size", "access", "avx_bcast", "avx_zero_opmask");
        }
    }

    public static class OpValue
    extends Union {
        public int reg;
        public long imm;
        public MemType mem;

        public List getFieldOrder() {
            return Arrays.asList("reg", "imm", "mem");
        }
    }

    public static class Encoding
    extends Structure {
        public byte modrmOffset;
        public byte dispOffset;
        public byte dispSize;
        public byte immOffset;
        public byte immSize;

        public List getFieldOrder() {
            return Arrays.asList("modrmOffset", "dispOffset", "dispSize", "immOffset", "immSize");
        }
    }

    public static class MemType
    extends Structure {
        public int segment;
        public int base;
        public int index;
        public int scale;
        public long disp;

        public List getFieldOrder() {
            return Arrays.asList("segment", "base", "index", "scale", "disp");
        }
    }
}

