/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        boolean writeClassName = serializer2.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(features, SerializerFeature.WriteClassName);
        SerializeWriter out = serializer2.out;
        Type elementType = null;
        if (writeClassName) {
            elementType = TypeUtils.getCollectionItemType(fieldType);
        }
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer2.context;
        serializer2.setContext(context, object, fieldName, 0);
        ObjectSerializer itemSerializer = null;
        try {
            if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                out.append('[');
                serializer2.incrementIndent();
                int i = 0;
                for (Object item : list) {
                    if (i != 0) {
                        out.append(',');
                    }
                    serializer2.println();
                    if (item != null) {
                        if (serializer2.containsReference(item)) {
                            serializer2.writeReference(item);
                        } else {
                            SerialContext itemContext;
                            itemSerializer = serializer2.getObjectWriter(item.getClass());
                            serializer2.context = itemContext = new SerialContext(context, object, fieldName, 0, 0);
                            itemSerializer.write(serializer2, item, i, elementType, features);
                        }
                    } else {
                        serializer2.out.writeNull();
                    }
                    ++i;
                }
                serializer2.decrementIdent();
                serializer2.println();
                out.append(']');
                return;
            }
            out.append('[');
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object item = list.get(i);
                if (i != 0) {
                    out.append(',');
                }
                if (item == null) {
                    out.append("null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    if (writeClassName) {
                        out.writeLong(val);
                        out.write(76);
                        continue;
                    }
                    out.writeLong(val);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & features) != 0) {
                    itemSerializer = serializer2.getObjectWriter(item.getClass());
                    itemSerializer.write(serializer2, item, i, elementType, features);
                    continue;
                }
                if (!out.disableCircularReferenceDetect) {
                    SerialContext itemContext;
                    serializer2.context = itemContext = new SerialContext(context, object, fieldName, 0, 0);
                }
                if (serializer2.containsReference(item)) {
                    serializer2.writeReference(item);
                    continue;
                }
                itemSerializer = serializer2.getObjectWriter(item.getClass());
                if ((SerializerFeature.WriteClassName.mask & features) != 0 && itemSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)itemSerializer;
                    javaBeanSerializer.writeNoneASM(serializer2, item, i, elementType, features);
                    continue;
                }
                itemSerializer.write(serializer2, item, i, elementType, features);
            }
            out.append(']');
        }
        finally {
            serializer2.context = context;
        }
    }
}

