/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.RegContext;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ArmHook
extends ArmSvc {
    private static final Log log = LogFactory.getLog(ArmHook.class);
    private final boolean enablePostCall;
    private RegContext regContext;

    protected ArmHook() {
        this(false);
    }

    protected ArmHook(boolean enablePostCall) {
        this.enablePostCall = enablePostCall;
    }

    public ArmHook(String name, boolean enablePostCall) {
        super(name);
        this.enablePostCall = enablePostCall;
    }

    @Override
    public final UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        byte[] code;
        if (this.enablePostCall) {
            try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
                KeystoneEncoded encoded = keystone.assemble(Arrays.asList("svc #0x" + Integer.toHexString(svcNumber), "pop {r7}", "cmp r7, #0", "bxeq lr", "blx r7", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34952), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "bx lr"));
                code = encoded.getMachineCode();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(ArmSvc.assembleSvc(svcNumber));
            buffer.putInt(-459411452);
            code = buffer.array();
        }
        String name = this.getName();
        UnidbgPointer pointer = svcMemory.allocate(code.length, name == null ? "ArmHook" : name);
        pointer.write(0L, code, 0, code.length);
        if (log.isDebugEnabled()) {
            log.debug("ARM hook: pointer=" + pointer);
        }
        return pointer;
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
        super.handlePostCallback(emulator);
        if (this.regContext == null) {
            throw new IllegalStateException();
        }
        this.regContext.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long handle(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.enablePostCall) {
            this.regContext = RegContext.backupContext(emulator, 70, 71, 72, 73, 10);
        }
        UnidbgPointer sp = UnidbgPointer.register(emulator, 12);
        try {
            HookStatus status = this.hook(emulator);
            if (status.forward || !this.enablePostCall) {
                sp = sp.share(-4L, 0L);
                sp.setInt(0L, (int)status.jump);
            } else {
                sp = sp.share(-4L, 0L);
                sp.setInt(0L, 0);
            }
            long l = status.returnValue;
            return l;
        }
        finally {
            backend.reg_write(12, sp.peer);
        }
    }

    protected abstract HookStatus hook(Emulator<?> var1);
}

