/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ThumbSvc
implements Svc {
    public static final int SVC_MAX = 255;
    private final String name;

    public static short assembleSvc(int svcNumber) {
        if (svcNumber >= 0 && svcNumber < 254) {
            return (short)(0xDF00 | svcNumber);
        }
        throw new IllegalStateException("svcNumber=0x" + Integer.toHexString(svcNumber));
    }

    public ThumbSvc() {
        this(null);
    }

    public ThumbSvc(String name) {
        this.name = name;
    }

    @Override
    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort(ThumbSvc.assembleSvc(svcNumber));
        buffer.putShort((short)18288);
        byte[] code = buffer.array();
        String name = this.getName();
        UnidbgPointer pointer = svcMemory.allocate(code.length, name == null ? "ThumbSvc" : name);
        pointer.write(code);
        return pointer;
    }

    @Override
    public void handlePostCallback(Emulator<?> emulator) {
    }

    @Override
    public void handlePreCallback(Emulator<?> emulator) {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

