/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import capstone.api.arm64.OpInfo;
import capstone.api.arm64.Operand;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.TraceFunctionCall;
import com.github.unidbg.debugger.FunctionCallListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class TraceFunctionCall64
extends TraceFunctionCall {
    private static final int BL_MASK = -67108864;
    private static final int BL = -1811939328;
    private static final int BLR_MASK = -993;
    private static final int BLR = -700514304;

    public TraceFunctionCall64(Emulator<?> emulator, FunctionCallListener listener) {
        super(emulator, listener);
    }

    @Override
    protected Instruction disassemble(long address, int size) {
        if (size != 4) {
            throw new IllegalStateException();
        }
        byte[] code = this.emulator.getBackend().mem_read(address, 4L);
        ByteBuffer buffer = ByteBuffer.wrap(code).order(ByteOrder.LITTLE_ENDIAN);
        int value = buffer.getInt();
        if ((value & 0xFC000000) == -1811939328) {
            Instruction[] instructions = this.emulator.disassemble(address, code, false, 1L);
            return instructions[0];
        }
        if ((value & 0xFFFFFC1F) == -700514304) {
            Instruction[] instructions = this.emulator.disassemble(address, code, false, 1L);
            return instructions[0];
        }
        return null;
    }

    @Override
    protected void onInstruction(Instruction instruction) {
        Number[] args;
        long functionAddress;
        String mnemonic = instruction.getMnemonic();
        Object context = this.emulator.getContext();
        if ("bl".equals(mnemonic) || "blr".equals(mnemonic)) {
            OpInfo operands = (OpInfo)instruction.getOperands();
            Operand operand = operands.getOperands()[0];
            switch (operand.getType()) {
                case 2: {
                    functionAddress = operand.getValue().getImm();
                    break;
                }
                case 1: {
                    functionAddress = context.getLongByReg(instruction.mapToUnicornReg(operand.getValue().getReg()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("type=" + operand.getType());
                }
            }
            args = new Number[8];
            for (int i = 0; i < args.length; ++i) {
                args[i] = context.getLongArg(i);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.pushFunction(instruction.getAddress(), functionAddress, instruction.getAddress() + (long)instruction.getSize(), args);
    }
}

