/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.UnicornBackend;
import java.util.Collection;

public abstract class BackendFactory {
    private final boolean fallbackUnicorn;

    protected BackendFactory(boolean fallbackUnicorn) {
        this.fallbackUnicorn = fallbackUnicorn;
    }

    private Backend newBackend(Emulator<?> emulator, boolean is64Bit) {
        try {
            return this.newBackendInternal(emulator, is64Bit);
        }
        catch (Throwable e) {
            if (this.fallbackUnicorn) {
                return null;
            }
            throw e;
        }
    }

    protected abstract Backend newBackendInternal(Emulator<?> var1, boolean var2);

    public static Backend createBackend(Emulator<?> emulator, boolean is64Bit, Collection<BackendFactory> backendFactories) {
        if (backendFactories != null) {
            for (BackendFactory factory : backendFactories) {
                Backend backend = factory.newBackend(emulator, is64Bit);
                if (backend == null) continue;
                return backend;
            }
        }
        return new UnicornBackend(emulator, is64Bit);
    }
}

