/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.BlockHook;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.FastBackend;
import com.github.unidbg.arm.backend.InterruptHook;
import com.github.unidbg.arm.backend.InterruptHookNotifier;
import com.github.unidbg.arm.backend.hypervisor.Hypervisor;
import com.github.unidbg.arm.backend.hypervisor.HypervisorCallback;
import com.github.unidbg.arm.backend.hypervisor.HypervisorException;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HypervisorBackend
extends FastBackend
implements Backend,
HypervisorCallback {
    private static final Log log = LogFactory.getLog(HypervisorBackend.class);
    protected final Hypervisor hypervisor;
    private final int pageSize;
    protected EventMemHookNotifier eventMemHookNotifier;
    protected InterruptHookNotifier interruptHookNotifier;
    protected long until;

    protected HypervisorBackend(Emulator<?> emulator, Hypervisor hypervisor) throws BackendException {
        super(emulator);
        this.hypervisor = hypervisor;
        this.pageSize = Hypervisor.getPageSize();
        try {
            this.hypervisor.setHypervisorCallback(this);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        this.mem_map(0xF0000000L, this.getPageSize(), 5);
        ByteBuffer buffer = ByteBuffer.allocate(this.getPageSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            if (buffer.position() == 1024) {
                buffer.putInt(-738197502);
                buffer.putInt(-694221856);
                continue;
            }
            buffer.putInt(-736096000);
        }
        UnidbgPointer ptr = UnidbgPointer.pointer(this.emulator, 0xF0000000L);
        assert (ptr != null);
        ptr.write(buffer.array());
    }

    @Override
    public byte[] reg_read_vector(int regId) throws BackendException {
        try {
            if (regId >= 104 && regId <= 135) {
                return this.hypervisor.reg_read_vector(regId - 104);
            }
            throw new UnsupportedOperationException("regId=" + regId);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        try {
            if (vector.length != 16) {
                throw new IllegalStateException("Invalid vector size");
            }
            if (regId < 104 || regId > 135) {
                throw new UnsupportedOperationException("regId=" + regId);
            }
            this.hypervisor.reg_set_vector(regId - 104, vector);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public byte[] mem_read(long address, long size) throws BackendException {
        try {
            return this.hypervisor.mem_read(address, (int)size);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void mem_write(long address, byte[] bytes) throws BackendException {
        try {
            this.hypervisor.mem_write(address, bytes);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void mem_map(long address, long size, int perms) throws BackendException {
        try {
            this.hypervisor.mem_map(address, size, perms);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void mem_protect(long address, long size, int perms) throws BackendException {
        try {
            this.hypervisor.mem_protect(address, size, perms);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void mem_unmap(long address, long size) throws BackendException {
        try {
            this.hypervisor.mem_unmap(address, size);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(EventMemHook callback2, int type, Object user_data) throws BackendException {
        if (this.eventMemHookNotifier != null) {
            throw new IllegalStateException();
        }
        this.eventMemHookNotifier = new EventMemHookNotifier(callback2, type, user_data);
    }

    @Override
    public void hook_add_new(InterruptHook callback2, Object user_data) throws BackendException {
        if (this.interruptHookNotifier != null) {
            throw new IllegalStateException();
        }
        this.interruptHookNotifier = new InterruptHookNotifier(callback2, user_data);
    }

    protected final void callSVC(long pc, int swi) {
        if (log.isDebugEnabled()) {
            log.debug("callSVC pc=0x" + Long.toHexString(pc) + ", until=0x" + Long.toHexString(this.until) + ", swi=" + swi);
        }
        if (pc == this.until) {
            this.emu_stop();
            return;
        }
        this.interruptHookNotifier.notifyCallSVC(this, 2, swi);
    }

    @Override
    public void hook_add_new(BlockHook callback2, long begin, long end, Object user_data) throws BackendException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final synchronized void emu_start(long begin, long until, long timeout, long count) throws BackendException {
        if (log.isDebugEnabled()) {
            log.debug("emu_start begin=0x" + Long.toHexString(begin) + ", until=0x" + Long.toHexString(until) + ", timeout=" + timeout + ", count=" + count);
        }
        this.until = until + 4L;
        try {
            this.hypervisor.emu_start(begin);
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void emu_stop() throws BackendException {
        try {
            this.hypervisor.emu_stop();
        }
        catch (HypervisorException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void destroy() throws BackendException {
        IOUtils.close(this.hypervisor);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    protected class EventMemHookNotifier {
        private final EventMemHook callback;
        private final int type;
        private final Object user;

        public EventMemHookNotifier(EventMemHook callback2, int type, Object user) {
            this.callback = callback2;
            this.type = type;
            this.user = user;
        }

        public void notifyDataAbort(boolean isWrite, int size, long address) {
            if (isWrite) {
                if ((this.type & 0x20) != 0) {
                    this.callback.hook(HypervisorBackend.this, address, size, 0L, this.user, EventMemHook.UnmappedType.Write);
                }
            } else if ((this.type & 0x10) != 0) {
                this.callback.hook(HypervisorBackend.this, address, size, 0L, this.user, EventMemHook.UnmappedType.Read);
            }
        }

        public void notifyInsnAbort(long address) {
            if ((this.type & 0x40) != 0) {
                this.callback.hook(HypervisorBackend.this, address, 4, 0L, this.user, EventMemHook.UnmappedType.Fetch);
            }
        }
    }
}

